/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;

public class SqlInfixOperator
extends SqlSpecialOperator {
    private final String[] names;

    protected SqlInfixOperator(String[] names, SqlKind kind, int precedence, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
        super(names[0], kind, precedence, true, returnTypeInference, operandTypeInference, operandTypeChecker);
        assert (names.length > 1);
        this.names = names;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        assert (call.operandCount() == this.names.length + 1);
        boolean needWhitespace = this.needsSpace();
        for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
            if (operand.i > 0) {
                writer.setNeedWhitespace(needWhitespace);
                writer.keyword(this.names[operand.i - 1]);
                writer.setNeedWhitespace(needWhitespace);
            }
            ((SqlNode)operand.e).unparse(writer, leftPrec, this.getLeftPrec());
        }
    }
}

