/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.logical;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelInput;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelShuttle;
import com.hazelcast.org.apache.calcite.rel.RelWriter;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.hint.RelHint;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class LogicalJoin
extends Join {
    private final boolean semiJoinDone;
    private final ImmutableList<RelDataTypeField> systemFieldList;

    public LogicalJoin(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        super(cluster, traitSet, hints, left, right, condition, variablesSet, joinType);
        this.semiJoinDone = semiJoinDone;
        this.systemFieldList = Objects.requireNonNull(systemFieldList);
    }

    @Deprecated
    public LogicalJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        this(cluster, traitSet, ImmutableList.of(), left, right, condition, variablesSet, joinType, semiJoinDone, systemFieldList);
    }

    @Deprecated
    public LogicalJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        this(cluster, traitSet, ImmutableList.of(), left, right, condition, CorrelationId.setOf(variablesStopped), joinType, semiJoinDone, systemFieldList);
    }

    @Deprecated
    public LogicalJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), ImmutableList.of(), left, right, condition, CorrelationId.setOf(variablesStopped), joinType, false, ImmutableList.of());
    }

    @Deprecated
    public LogicalJoin(RelOptCluster cluster, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        this(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), ImmutableList.of(), left, right, condition, CorrelationId.setOf(variablesStopped), joinType, semiJoinDone, systemFieldList);
    }

    public LogicalJoin(RelInput input) {
        this(input.getCluster(), input.getCluster().traitSetOf((RelTrait)Convention.NONE), new ArrayList<RelHint>(), input.getInputs().get(0), input.getInputs().get(1), input.getExpression("condition"), ImmutableSet.of(), input.getEnum("joinType", JoinRelType.class), false, ImmutableList.of());
    }

    public static LogicalJoin create(RelNode left, RelNode right, List<RelHint> hints, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType) {
        return LogicalJoin.create(left, right, hints, condition, variablesSet, joinType, false, ImmutableList.of());
    }

    public static LogicalJoin create(RelNode left, RelNode right, List<RelHint> hints, RexNode condition, Set<CorrelationId> variablesSet, JoinRelType joinType, boolean semiJoinDone, ImmutableList<RelDataTypeField> systemFieldList) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalJoin(cluster, traitSet, hints, left, right, condition, variablesSet, joinType, semiJoinDone, systemFieldList);
    }

    @Override
    public LogicalJoin copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalJoin(this.getCluster(), this.getCluster().traitSetOf((RelTrait)Convention.NONE), this.hints, left, right, conditionExpr, this.variablesSet, joinType, semiJoinDone, this.systemFieldList);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("semiJoinDone", this.semiJoinDone, this.semiJoinDone);
    }

    @Override
    public boolean isSemiJoinDone() {
        return this.semiJoinDone;
    }

    @Override
    public List<RelDataTypeField> getSystemFieldList() {
        return this.systemFieldList;
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalJoin(this.getCluster(), this.traitSet, hintList, this.left, this.right, this.condition, this.variablesSet, this.joinType, this.semiJoinDone, this.systemFieldList);
    }
}

