/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.AbstractGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nonnull;

public class PortableGenericRecord
extends AbstractGenericRecord {
    private final ClassDefinition classDefinition;
    private final Object[] objects;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PortableGenericRecord(ClassDefinition classDefinition, Object[] objects) {
        this.classDefinition = classDefinition;
        this.objects = objects;
    }

    public ClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    @Override
    @Nonnull
    public GenericRecord.Builder newBuilder() {
        return GenericRecord.Builder.portable(this.classDefinition);
    }

    @Override
    @Nonnull
    public GenericRecord.Builder cloneWithBuilder() {
        return new PortableGenericRecordBuilder(this.classDefinition, Arrays.copyOf(this.objects, this.objects.length));
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.classDefinition.getFieldNames();
    }

    @Override
    public GenericRecord[] readGenericRecordArray(@Nonnull String fieldName) {
        return (GenericRecord[])this.read(fieldName, FieldType.PORTABLE_ARRAY);
    }

    @Override
    public GenericRecord readGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.read(fieldName, FieldType.PORTABLE);
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.classDefinition.hasField(fieldName);
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.classDefinition.getFieldType(fieldName);
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName) {
        return (Boolean)this.read(fieldName, FieldType.BOOLEAN);
    }

    @Override
    public byte readByte(@Nonnull String fieldName) {
        return (Byte)this.read(fieldName, FieldType.BYTE);
    }

    @Override
    public char readChar(@Nonnull String fieldName) {
        return ((Character)this.read(fieldName, FieldType.CHAR)).charValue();
    }

    @Override
    public double readDouble(@Nonnull String fieldName) {
        return (Double)this.read(fieldName, FieldType.DOUBLE);
    }

    @Override
    public float readFloat(@Nonnull String fieldName) {
        return ((Float)this.read(fieldName, FieldType.FLOAT)).floatValue();
    }

    @Override
    public int readInt(@Nonnull String fieldName) {
        return (Integer)this.read(fieldName, FieldType.INT);
    }

    @Override
    public long readLong(@Nonnull String fieldName) {
        return (Long)this.read(fieldName, FieldType.LONG);
    }

    @Override
    public short readShort(@Nonnull String fieldName) {
        return (Short)this.read(fieldName, FieldType.SHORT);
    }

    @Override
    public String readUTF(@Nonnull String fieldName) {
        return (String)this.read(fieldName, FieldType.UTF);
    }

    @Override
    public boolean[] readBooleanArray(@Nonnull String fieldName) {
        return (boolean[])this.read(fieldName, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    public byte[] readByteArray(@Nonnull String fieldName) {
        return (byte[])this.read(fieldName, FieldType.BYTE_ARRAY);
    }

    @Override
    public char[] readCharArray(@Nonnull String fieldName) {
        return (char[])this.read(fieldName, FieldType.CHAR_ARRAY);
    }

    @Override
    public double[] readDoubleArray(@Nonnull String fieldName) {
        return (double[])this.read(fieldName, FieldType.DOUBLE_ARRAY);
    }

    @Override
    public float[] readFloatArray(@Nonnull String fieldName) {
        return (float[])this.read(fieldName, FieldType.FLOAT_ARRAY);
    }

    @Override
    public int[] readIntArray(@Nonnull String fieldName) {
        return (int[])this.read(fieldName, FieldType.INT_ARRAY);
    }

    @Override
    public long[] readLongArray(@Nonnull String fieldName) {
        return (long[])this.read(fieldName, FieldType.LONG_ARRAY);
    }

    @Override
    public short[] readShortArray(@Nonnull String fieldName) {
        return (short[])this.read(fieldName, FieldType.SHORT_ARRAY);
    }

    @Override
    public String[] readUTFArray(@Nonnull String fieldName) {
        return (String[])this.read(fieldName, FieldType.UTF_ARRAY);
    }

    private <T> T read(String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.check(fieldName, fieldType);
        return (T)this.objects[fd.getIndex()];
    }

    @Nonnull
    private FieldDefinition check(String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.classDefinition.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}");
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}, expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
        return fd;
    }

    @Override
    protected Object getClassIdentifier() {
        return this.classDefinition;
    }

    @Override
    public String toString() {
        return "PortableGenericRecord:" + super.toString();
    }
}

