/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

public final class DoubleConverter
extends Converter {
    public static final DoubleConverter INSTANCE = new DoubleConverter();

    private DoubleConverter() {
        super(8, QueryDataTypeFamily.DOUBLE);
    }

    @Override
    public Class<?> getValueClass() {
        return Double.class;
    }

    @Override
    public byte asTinyint(Object val) {
        double casted = this.cast(val);
        if (!Double.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.TINYINT, val);
        }
        byte converted = (byte)casted;
        if (converted != (int)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.TINYINT, val);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        double casted = this.cast(val);
        if (!Double.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.SMALLINT, val);
        }
        short converted = (short)casted;
        if (converted != (int)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.SMALLINT, val);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        double casted = this.cast(val);
        if (!Double.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.INTEGER, val);
        }
        int converted = (int)casted;
        if ((long)converted != (long)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.INTEGER, val);
        }
        return converted;
    }

    @Override
    public long asBigint(Object val) {
        double casted = this.cast(val);
        if (!Double.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.BIGINT, val);
        }
        double truncated = casted > 0.0 ? Math.floor(casted) : Math.ceil(casted);
        long converted = (long)truncated;
        if ((double)converted != truncated) {
            throw this.numericOverflow(QueryDataTypeFamily.BIGINT, val);
        }
        return converted;
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        double val0 = this.cast(val);
        if (Double.isInfinite(val0)) {
            throw QueryException.dataException("Cannot convert infinite " + (Object)((Object)QueryDataTypeFamily.DOUBLE) + " value to " + (Object)((Object)QueryDataTypeFamily.DECIMAL));
        }
        if (Double.isNaN(val0)) {
            throw QueryException.dataException("Cannot convert NaN " + (Object)((Object)QueryDataTypeFamily.DOUBLE) + " value to " + (Object)((Object)QueryDataTypeFamily.DECIMAL));
        }
        return new BigDecimal(val0, ExpressionMath.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return (float)this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Double.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asDouble(val);
    }

    private double cast(Object val) {
        return (Double)val;
    }
}

