/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.operation.QueryExecuteOperation;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragment;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragmentMapping;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.PlanFragmentMapping;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class QueryExecuteOperationFactory {
    private final Plan plan;
    private final List<Object> args;
    private final Map<Integer, Long> edgeInitialMemoryMap;

    public QueryExecuteOperationFactory(Plan plan, List<Object> args, Map<Integer, Long> edgeInitialMemoryMap) {
        this.plan = plan;
        this.args = args;
        this.edgeInitialMemoryMap = edgeInitialMemoryMap;
    }

    public QueryExecuteOperation create(QueryId queryId, UUID targetMemberId) {
        int fragmentCount = this.plan.getFragmentCount();
        ArrayList<QueryExecuteOperationFragment> fragments = new ArrayList<QueryExecuteOperationFragment>(fragmentCount);
        for (int i = 0; i < fragmentCount; ++i) {
            PlanNode node;
            Collection<UUID> memberIds;
            QueryExecuteOperationFragmentMapping mapping;
            PlanFragmentMapping planMapping = this.plan.getFragmentMapping(i);
            if (planMapping.isDataMembers()) {
                mapping = QueryExecuteOperationFragmentMapping.DATA_MEMBERS;
                memberIds = null;
                node = this.plan.getFragment(i);
            } else {
                mapping = QueryExecuteOperationFragmentMapping.EXPLICIT;
                memberIds = planMapping.getMemberIds();
                node = memberIds.contains(targetMemberId) ? this.plan.getFragment(i) : null;
            }
            fragments.add(new QueryExecuteOperationFragment(node, mapping, memberIds));
        }
        return new QueryExecuteOperation(queryId, this.plan.getPartitionMap(), fragments, this.plan.getOutboundEdgeMap(), this.plan.getInboundEdgeMap(), this.edgeInitialMemoryMap, this.args);
    }
}

