/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.schema;

import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelDistribution;
import com.hazelcast.org.apache.calcite.rel.RelReferentialConstraint;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMdUtil;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelRecordType;
import com.hazelcast.org.apache.calcite.rel.type.StructKind;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.schema.Statistic;
import com.hazelcast.org.apache.calcite.schema.impl.AbstractTable;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.sql.impl.calcite.opt.cost.CostUtils;
import com.hazelcast.sql.impl.calcite.schema.HazelcastSchemaUtils;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class HazelcastTable
extends AbstractTable {
    private final Table target;
    private final Statistic statistic;
    private final List<Integer> projects;
    private final RexNode filter;
    private RelDataType rowType;
    private Set<String> hiddenFieldNames;

    public HazelcastTable(Table target, Statistic statistic) {
        this(target, statistic, null, null);
    }

    private HazelcastTable(Table target, Statistic statistic, List<Integer> projects, RexNode filter) {
        this.target = target;
        this.statistic = statistic;
        this.projects = projects;
        this.filter = filter;
    }

    public HazelcastTable withProject(List<Integer> projects) {
        return new HazelcastTable(this.target, this.statistic, projects, this.filter);
    }

    public HazelcastTable withFilter(RexNode filter) {
        return new HazelcastTable(this.target, this.statistic, this.projects, filter);
    }

    @Nonnull
    public List<Integer> getProjects() {
        if (this.projects == null) {
            int fieldCount = this.target.getFieldCount();
            ArrayList<Integer> res = new ArrayList<Integer>(fieldCount);
            for (int i = 0; i < fieldCount; ++i) {
                res.add(i);
            }
            return res;
        }
        return this.projects;
    }

    public RexNode getFilter() {
        return this.filter;
    }

    public <T extends Table> T getTarget() {
        return (T)this.target;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.rowType != null) {
            return this.rowType;
        }
        this.hiddenFieldNames = new HashSet<String>();
        List<Integer> projects = this.getProjects();
        ArrayList<RelDataTypeField> convertedFields = new ArrayList<RelDataTypeField>(projects.size());
        for (Integer project : projects) {
            Object field = this.target.getField(project);
            String fieldName = ((TableField)field).getName();
            RelDataType relType = HazelcastSchemaUtils.convert(field, typeFactory);
            RelDataTypeFieldImpl convertedField = new RelDataTypeFieldImpl(fieldName, convertedFields.size(), relType);
            convertedFields.add(convertedField);
            if (!((TableField)field).isHidden()) continue;
            this.hiddenFieldNames.add(fieldName);
        }
        this.rowType = new RelRecordType(StructKind.PEEK_FIELDS, convertedFields, false);
        return this.rowType;
    }

    @Override
    public Statistic getStatistic() {
        if (this.filter == null) {
            return this.statistic;
        }
        Double selectivity = RelMdUtil.guessSelectivity(this.filter);
        double rowCount = CostUtils.adjustFilteredRowCount(this.statistic.getRowCount(), selectivity);
        return new AdjustedStatistic(rowCount);
    }

    public double getTotalRowCount() {
        return this.statistic.getRowCount();
    }

    public boolean isHidden(String fieldName) {
        assert (this.hiddenFieldNames != null);
        return this.hiddenFieldNames.contains(fieldName);
    }

    public int getOriginalFieldCount() {
        return this.target.getFieldCount();
    }

    public String getSignature() {
        StringJoiner res = new StringJoiner(", ", "[", "]");
        res.setEmptyValue("");
        res.add("projects=" + this.getProjects().stream().map(Objects::toString).collect(Collectors.joining(", ", "[", "]")));
        if (this.filter != null) {
            res.add("filter=" + this.filter);
        }
        return res.toString();
    }

    private final class AdjustedStatistic
    implements Statistic {
        private final double rowCount;

        private AdjustedStatistic(double rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public Double getRowCount() {
            return this.rowCount;
        }

        @Override
        public boolean isKey(ImmutableBitSet columns) {
            return HazelcastTable.this.statistic.isKey(columns);
        }

        @Override
        public List<ImmutableBitSet> getKeys() {
            return HazelcastTable.this.statistic.getKeys();
        }

        @Override
        public List<RelReferentialConstraint> getReferentialConstraints() {
            return HazelcastTable.this.statistic.getReferentialConstraints();
        }

        @Override
        public List<RelCollation> getCollations() {
            return HazelcastTable.this.statistic.getCollations();
        }

        @Override
        public RelDistribution getDistribution() {
            return HazelcastTable.this.statistic.getDistribution();
        }
    }
}

