/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.hint;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class RelHint {
    public final ImmutableList<Integer> inheritPath;
    public final String hintName;
    public final List<String> listOptions;
    public final Map<String, String> kvOptions;

    private RelHint(Iterable<Integer> inheritPath, String hintName, @Nullable List<String> listOption, @Nullable Map<String, String> kvOptions) {
        Objects.requireNonNull(inheritPath);
        Objects.requireNonNull(hintName);
        this.inheritPath = ImmutableList.copyOf(inheritPath);
        this.hintName = hintName;
        this.listOptions = listOption == null ? ImmutableList.of() : ImmutableList.copyOf(listOption);
        this.kvOptions = kvOptions == null ? ImmutableMap.of() : ImmutableMap.copyOf(kvOptions);
    }

    public static Builder builder(String hintName) {
        return new Builder(hintName);
    }

    public RelHint copy(List<Integer> inheritPath) {
        Objects.requireNonNull(inheritPath);
        return new RelHint(inheritPath, this.hintName, this.listOptions, this.kvOptions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelHint)) {
            return false;
        }
        RelHint that = (RelHint)obj;
        return this.hintName.equals(that.hintName) && this.inheritPath.equals(that.inheritPath) && Objects.equals(this.listOptions, that.listOptions) && Objects.equals(this.kvOptions, that.kvOptions);
    }

    public int hashCode() {
        return Objects.hash(this.hintName, this.inheritPath, this.listOptions, this.kvOptions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.hintName).append(" inheritPath:").append(this.inheritPath);
        if (this.listOptions.size() > 0 || this.kvOptions.size() > 0) {
            builder.append(" options:");
            if (this.listOptions.size() > 0) {
                builder.append(this.listOptions.toString());
            } else {
                builder.append(this.kvOptions.toString());
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public static class Builder {
        private String hintName;
        private List<Integer> inheritPath;
        private List<String> listOptions = new ArrayList<String>();
        private Map<String, String> kvOptions = new LinkedHashMap<String, String>();

        private Builder(String hintName) {
            this.hintName = hintName;
            this.inheritPath = ImmutableList.of();
        }

        public Builder inheritPath(Iterable<Integer> inheritPath) {
            this.inheritPath = ImmutableList.copyOf(Objects.requireNonNull(inheritPath));
            return this;
        }

        public Builder inheritPath(Integer ... inheritPath) {
            this.inheritPath = Arrays.asList(inheritPath);
            return this;
        }

        public Builder hintOption(String hintOption) {
            Objects.requireNonNull(hintOption);
            Preconditions.checkState(this.kvOptions.size() == 0, "List options and key value options can not be mixed in");
            this.listOptions.add(hintOption);
            return this;
        }

        public Builder hintOptions(Iterable<String> hintOptions) {
            Objects.requireNonNull(hintOptions);
            Preconditions.checkState(this.kvOptions.size() == 0, "List options and key value options can not be mixed in");
            this.listOptions = ImmutableList.copyOf(hintOptions);
            return this;
        }

        public Builder hintOption(String optionKey, String optionValue) {
            Objects.requireNonNull(optionKey);
            Objects.requireNonNull(optionValue);
            Preconditions.checkState(this.listOptions.size() == 0, "List options and key value options can not be mixed in");
            this.kvOptions.put(optionKey, optionValue);
            return this;
        }

        public Builder hintOptions(Map<String, String> kvOptions) {
            Objects.requireNonNull(kvOptions);
            Preconditions.checkState(this.listOptions.size() == 0, "List options and key value options can not be mixed in");
            this.kvOptions = kvOptions;
            return this;
        }

        public RelHint build() {
            return new RelHint(this.inheritPath, this.hintName, this.listOptions, this.kvOptions);
        }
    }
}

