/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.RepeatUnion;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;

public class EnumerableRepeatUnion
extends RepeatUnion
implements EnumerableRel {
    EnumerableRepeatUnion(RelOptCluster cluster, RelTraitSet traitSet, RelNode seed, RelNode iterative, boolean all, int iterationLimit) {
        super(cluster, traitSet, seed, iterative, all, iterationLimit);
    }

    @Override
    public EnumerableRepeatUnion copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.size() == 2);
        return new EnumerableRepeatUnion(this.getCluster(), traitSet, inputs.get(0), inputs.get(1), this.all, this.iterationLimit);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        RelNode seed = this.getSeedRel();
        RelNode iteration = this.getIterativeRel();
        EnumerableRel.Result seedResult = implementor.visitChild(this, 0, (EnumerableRel)seed, pref);
        EnumerableRel.Result iterationResult = implementor.visitChild(this, 1, (EnumerableRel)iteration, pref);
        Expression seedExp = builder.append("seed", seedResult.block);
        Expression iterativeExp = builder.append("iteration", iterationResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.prefer(seedResult.format));
        MethodCallExpression unionExp = Expressions.call(BuiltInMethod.REPEAT_UNION.method, seedExp, iterativeExp, Expressions.constant(this.iterationLimit, Integer.TYPE), Expressions.constant(this.all, Boolean.TYPE), Util.first(physType.comparer(), Expressions.call(BuiltInMethod.IDENTITY_COMPARER.method, new Expression[0])));
        builder.add(unionExp);
        return implementor.result(physType, builder.toBlock());
    }
}

