/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFamily;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastOperandTypes;
import com.hazelcast.sql.impl.calcite.validate.types.ReplaceUnknownOperandTypeInference;
import java.util.Arrays;

public class HazelcastSqlTrimFunction
extends SqlFunction {
    public HazelcastSqlTrimFunction() {
        super("TRIM", SqlKind.TRIM, ReturnTypes.ARG2_NULLABLE, new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), HazelcastOperandTypes.notAny(OperandTypes.family(SqlTypeFamily.ANY, SqlTypeFamily.STRING, SqlTypeFamily.STRING)), SqlFunctionCategory.STRING);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        assert (call.operand(0) instanceof SqlLiteral) : call.operand(0);
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        writer.sep("FROM");
        ((SqlNode)call.operand(2)).unparse(writer, leftPrec, rightPrec);
        writer.endFunCall(frame);
    }

    @Override
    public String getSignatureTemplate(int operandsCount) {
        assert (operandsCount == 3);
        return "{0}([BOTH|LEADING|TRAILING] {1} FROM {2})";
    }

    @Override
    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        switch (operands.length) {
            case 1: {
                operands = new SqlNode[]{SqlTrimFunction.Flag.BOTH.symbol(SqlParserPos.ZERO), SqlLiteral.createCharString(" ", pos), operands[0]};
                break;
            }
            case 3: {
                assert (operands[0] instanceof SqlLiteral && ((SqlLiteral)operands[0]).getValue() instanceof SqlTrimFunction.Flag);
                if (operands[1] != null) break;
                operands[1] = SqlLiteral.createCharString(" ", pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid operand count " + Arrays.toString(operands));
            }
        }
        return super.createCall(functionQualifier, pos, operands);
    }
}

