/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.ClockProvider;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.cache.CachedPlanInvalidationCallback;
import com.hazelcast.sql.impl.state.QueryState;
import com.hazelcast.sql.impl.state.QueryStateCompletionCallback;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class QueryStateRegistry {
    private final ConcurrentHashMap<QueryId, QueryState> states = new ConcurrentHashMap();
    private final ClockProvider clockProvider;
    private volatile boolean shutdown;

    public QueryStateRegistry(ClockProvider clockProvider) {
        this.clockProvider = clockProvider;
    }

    public QueryState onInitiatorQueryStarted(UUID localMemberId, long initiatorTimeout, Plan initiatorPlan, CachedPlanInvalidationCallback initiatorPlanInvalidationCallback, SqlRowMetadata initiatorRowMetadata, QueryResultProducer initiatorResultProducer, QueryStateCompletionCallback completionCallback) {
        QueryId queryId = QueryId.create(localMemberId);
        QueryState state = QueryState.createInitiatorState(queryId, localMemberId, completionCallback, initiatorTimeout, initiatorPlan, initiatorPlanInvalidationCallback, initiatorRowMetadata, initiatorResultProducer, this.clockProvider);
        this.states.put(queryId, state);
        if (this.shutdown) {
            this.states.remove(queryId);
            throw QueryStateRegistry.shutdownException();
        }
        return state;
    }

    public QueryState onDistributedQueryStarted(UUID localMemberId, QueryId queryId, QueryStateCompletionCallback completionCallback) {
        UUID initiatorMemberId = queryId.getMemberId();
        boolean local = localMemberId.equals(initiatorMemberId);
        if (local) {
            return this.states.get(queryId);
        }
        QueryState state = this.states.get(queryId);
        if (state == null) {
            state = QueryState.createDistributedState(queryId, localMemberId, completionCallback, this.clockProvider);
            QueryState oldState = this.states.putIfAbsent(queryId, state);
            if (oldState != null) {
                state = oldState;
            }
            if (this.shutdown) {
                QueryStateRegistry.cancelOnShutdown(state);
                return null;
            }
        }
        return state;
    }

    public void onQueryCompleted(QueryId queryId) {
        this.states.remove(queryId);
    }

    public void shutdown() {
        this.shutdown = true;
        for (QueryState state : this.states.values()) {
            QueryStateRegistry.cancelOnShutdown(state);
        }
    }

    public QueryState getState(QueryId queryId) {
        return this.states.get(queryId);
    }

    public Collection<QueryState> getStates() {
        return this.states.values();
    }

    private static void cancelOnShutdown(QueryState state) {
        state.cancel(QueryStateRegistry.shutdownException(), true);
    }

    private static QueryException shutdownException() {
        return QueryException.error("SQL query has been cancelled due to member shutdown");
    }
}

