/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.QueryException;
import java.math.MathContext;
import java.math.RoundingMode;

public final class ExpressionMath {
    public static final MathContext DECIMAL_MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_UP);

    private ExpressionMath() {
    }

    public static long divideExact(long left, long right) {
        if (left == Long.MIN_VALUE && right == -1L) {
            throw QueryException.error(2000, "BIGINT overflow in '/' operator (consider adding explicit CAST to DECIMAL)");
        }
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw QueryException.error(2000, "division by zero");
        }
    }

    public static double divideExact(double left, double right) {
        if (right == 0.0 || right == -0.0) {
            throw QueryException.error(2000, "division by zero");
        }
        return left / right;
    }

    public static float divideExact(float left, float right) {
        if (right == 0.0f || right == -0.0f) {
            throw QueryException.error(2000, "division by zero");
        }
        return left / right;
    }
}

