/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlModality;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.Static;

public class TableConstructorNamespace
extends AbstractNamespace {
    private final SqlCall values;
    private final SqlValidatorScope scope;

    TableConstructorNamespace(SqlValidatorImpl validator, SqlCall values, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.values = values;
        this.scope = scope;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.validateValues(this.values, targetRowType, this.scope);
        RelDataType tableConstructorRowType = this.validator.getTableConstructorRowType(this.values, this.scope);
        if (tableConstructorRowType == null) {
            throw this.validator.newValidationError(this.values, Static.RESOURCE.incompatibleTypes());
        }
        return tableConstructorRowType;
    }

    @Override
    public SqlNode getNode() {
        return this.values;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return modality == SqlModality.RELATION;
    }
}

