/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;

public class SqlReturnTypeInferenceChain
implements SqlReturnTypeInference {
    private final ImmutableList<SqlReturnTypeInference> rules;

    SqlReturnTypeInferenceChain(SqlReturnTypeInference ... rules) {
        assert (rules != null);
        assert (rules.length > 1);
        for (SqlReturnTypeInference rule : rules) {
            assert (rule != null);
        }
        this.rules = ImmutableList.copyOf(rules);
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        for (SqlReturnTypeInference rule : this.rules) {
            RelDataType ret = rule.inferReturnType(opBinding);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

