/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.sql.impl.NodeServiceProvider;
import com.hazelcast.sql.impl.exec.AbstractExec;
import com.hazelcast.sql.impl.exec.CreateExecPlanNodeVisitorCallback;
import com.hazelcast.sql.impl.exec.CreateExecPlanNodeVisitorHook;
import com.hazelcast.sql.impl.exec.EmptyExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.FilterExec;
import com.hazelcast.sql.impl.exec.ProjectExec;
import com.hazelcast.sql.impl.exec.io.InboundHandler;
import com.hazelcast.sql.impl.exec.io.Inbox;
import com.hazelcast.sql.impl.exec.io.OutboundHandler;
import com.hazelcast.sql.impl.exec.io.Outbox;
import com.hazelcast.sql.impl.exec.io.ReceiveExec;
import com.hazelcast.sql.impl.exec.io.SendExec;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControl;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControlFactory;
import com.hazelcast.sql.impl.exec.root.RootExec;
import com.hazelcast.sql.impl.exec.scan.MapScanExec;
import com.hazelcast.sql.impl.exec.scan.index.MapIndexScanExec;
import com.hazelcast.sql.impl.operation.QueryExecuteOperation;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragment;
import com.hazelcast.sql.impl.operation.QueryExecuteOperationFragmentMapping;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.plan.node.EmptyPlanNode;
import com.hazelcast.sql.impl.plan.node.FilterPlanNode;
import com.hazelcast.sql.impl.plan.node.MapIndexScanPlanNode;
import com.hazelcast.sql.impl.plan.node.MapScanPlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.ProjectPlanNode;
import com.hazelcast.sql.impl.plan.node.RootPlanNode;
import com.hazelcast.sql.impl.plan.node.io.EdgeAwarePlanNode;
import com.hazelcast.sql.impl.plan.node.io.ReceivePlanNode;
import com.hazelcast.sql.impl.plan.node.io.RootSendPlanNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CreateExecPlanNodeVisitor
implements PlanNodeVisitor {
    private final QueryOperationHandler operationHandler;
    private final NodeServiceProvider nodeServiceProvider;
    private final InternalSerializationService serializationService;
    private final UUID localMemberId;
    private final QueryExecuteOperation operation;
    private final FlowControlFactory flowControlFactory;
    private final PartitionIdSet localParts;
    private final int outboxBatchSize;
    private final CreateExecPlanNodeVisitorHook hook;
    private final ArrayList<Exec> stack = new ArrayList(1);
    private Exec exec;
    private final Map<Integer, InboundHandler> inboxes = new HashMap<Integer, InboundHandler>();
    private final Map<Integer, Map<UUID, OutboundHandler>> outboxes = new HashMap<Integer, Map<UUID, OutboundHandler>>();

    public CreateExecPlanNodeVisitor(QueryOperationHandler operationHandler, NodeServiceProvider nodeServiceProvider, InternalSerializationService serializationService, UUID localMemberId, QueryExecuteOperation operation, FlowControlFactory flowControlFactory, PartitionIdSet localParts, int outboxBatchSize, CreateExecPlanNodeVisitorHook hook) {
        this.operationHandler = operationHandler;
        this.nodeServiceProvider = nodeServiceProvider;
        this.serializationService = serializationService;
        this.localMemberId = localMemberId;
        this.operation = operation;
        this.flowControlFactory = flowControlFactory;
        this.localParts = localParts;
        this.outboxBatchSize = outboxBatchSize;
        this.hook = hook;
    }

    @Override
    public void onRootNode(RootPlanNode node) {
        assert (this.stack.size() == 1);
        this.exec = new RootExec(node.getId(), this.pop(), this.operation.getRootConsumer(), this.operation.getRootBatchSize());
    }

    @Override
    public void onReceiveNode(ReceivePlanNode node) {
        int edgeId = node.getEdgeId();
        int sendFragmentPos = this.operation.getOutboundEdgeMap().get(edgeId);
        QueryExecuteOperationFragment sendFragment = this.operation.getFragments().get(sendFragmentPos);
        int fragmentMemberCount = this.getFragmentMembers(sendFragment).size();
        Inbox inbox = new Inbox(this.operationHandler, this.operation.getQueryId(), edgeId, node.getSchema().getEstimatedRowSize(), this.localMemberId, fragmentMemberCount, this.createFlowControl(edgeId));
        this.inboxes.put(edgeId, inbox);
        ReceiveExec res = new ReceiveExec(node.getId(), inbox);
        this.push(res);
    }

    @Override
    public void onRootSendNode(RootSendPlanNode node) {
        Outbox[] outboxes = this.prepareOutboxes(node);
        assert (outboxes.length == 1);
        this.exec = new SendExec(node.getId(), this.pop(), outboxes[0]);
    }

    private Outbox[] prepareOutboxes(EdgeAwarePlanNode node) {
        int edgeId = node.getEdgeId();
        int rowWidth = node.getSchema().getEstimatedRowSize();
        int receiveFragmentPos = this.operation.getInboundEdgeMap().get(edgeId);
        QueryExecuteOperationFragment receiveFragment = this.operation.getFragments().get(receiveFragmentPos);
        Collection<UUID> receiveFragmentMemberIds = this.getFragmentMembers(receiveFragment);
        Outbox[] res = new Outbox[receiveFragmentMemberIds.size()];
        int i = 0;
        HashMap<UUID, Outbox> edgeOutboxes = new HashMap<UUID, Outbox>();
        this.outboxes.put(edgeId, edgeOutboxes);
        for (UUID receiveMemberId : receiveFragmentMemberIds) {
            Outbox outbox = new Outbox(this.operationHandler, this.operation.getQueryId(), edgeId, rowWidth, this.localMemberId, receiveMemberId, this.outboxBatchSize, this.operation.getEdgeInitialMemoryMap().get(edgeId));
            edgeOutboxes.put(receiveMemberId, outbox);
            res[i++] = outbox;
        }
        return res;
    }

    @Override
    public void onProjectNode(ProjectPlanNode node) {
        ProjectExec res = new ProjectExec(node.getId(), this.pop(), node.getProjects());
        this.push(res);
    }

    @Override
    public void onFilterNode(FilterPlanNode node) {
        FilterExec res = new FilterExec(node.getId(), this.pop(), node.getFilter());
        this.push(res);
    }

    @Override
    public void onEmptyNode(EmptyPlanNode node) {
        EmptyExec res = new EmptyExec(node.getId());
        this.push(res);
    }

    @Override
    public void onMapScanNode(MapScanPlanNode node) {
        String mapName;
        MapContainer map;
        AbstractExec res = this.localParts.isEmpty() ? new EmptyExec(node.getId()) : ((map = this.nodeServiceProvider.getMap(mapName = node.getMapName())) == null ? new EmptyExec(node.getId()) : new MapScanExec(node.getId(), map, this.localParts, node.getKeyDescriptor(), node.getValueDescriptor(), node.getFieldPaths(), node.getFieldTypes(), node.getProjects(), node.getFilter(), this.serializationService));
        this.push(res);
    }

    @Override
    public void onMapIndexScanNode(MapIndexScanPlanNode node) {
        String mapName;
        MapContainer map;
        AbstractExec res = this.localParts.isEmpty() ? new EmptyExec(node.getId()) : ((map = this.nodeServiceProvider.getMap(mapName = node.getMapName())) == null ? new EmptyExec(node.getId()) : new MapIndexScanExec(node.getId(), map, this.localParts, node.getKeyDescriptor(), node.getValueDescriptor(), node.getFieldPaths(), node.getFieldTypes(), node.getProjects(), node.getFilter(), this.serializationService, node.getIndexName(), node.getIndexComponentCount(), node.getIndexFilter(), node.getConverterTypes()));
        this.push(res);
    }

    @Override
    public void onOtherNode(PlanNode node) {
        if (!(node instanceof CreateExecPlanNodeVisitorCallback)) {
            throw new UnsupportedOperationException("Unsupported node: " + node);
        }
        ((CreateExecPlanNodeVisitorCallback)((Object)node)).onVisit(this);
    }

    public Exec getExec() {
        return this.exec;
    }

    public void setExec(Exec exec) {
        this.exec = exec;
    }

    public Map<Integer, InboundHandler> getInboxes() {
        return this.inboxes;
    }

    public Map<Integer, Map<UUID, OutboundHandler>> getOutboxes() {
        return this.outboxes;
    }

    public Exec pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    public void push(Exec exec) {
        CreateExecPlanNodeVisitorHook hook0 = this.hook;
        if (hook0 != null) {
            exec = hook0.onExec(exec);
        }
        this.stack.add(exec);
    }

    private FlowControl createFlowControl(int edgeId) {
        long initialMemory = this.operation.getEdgeInitialMemoryMap().get(edgeId);
        return this.flowControlFactory.create(initialMemory);
    }

    private Collection<UUID> getFragmentMembers(QueryExecuteOperationFragment fragment) {
        if (fragment.getMapping() == QueryExecuteOperationFragmentMapping.EXPLICIT) {
            return fragment.getMemberIds();
        }
        assert (fragment.getMapping() == QueryExecuteOperationFragmentMapping.DATA_MEMBERS);
        return this.operation.getPartitionMap().keySet();
    }
}

