/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumUtils;
import com.hazelcast.org.apache.calcite.adapter.enumerable.NotNullImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.MethodCallExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.NewExpression;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import java.lang.reflect.Method;
import java.util.List;

public class ReflectiveCallNotNullImplementor
implements NotNullImplementor {
    protected final Method method;

    public ReflectiveCallNotNullImplementor(Method method) {
        this.method = method;
    }

    @Override
    public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
        MethodCallExpression callExpr;
        translatedOperands = EnumUtils.fromInternal(this.method.getParameterTypes(), translatedOperands);
        translatedOperands = EnumUtils.convertAssignableTypes(this.method.getParameterTypes(), translatedOperands);
        if ((this.method.getModifiers() & 8) != 0) {
            callExpr = Expressions.call(this.method, translatedOperands);
        } else {
            NewExpression target = Expressions.new_(this.method.getDeclaringClass());
            callExpr = Expressions.call((Expression)target, this.method, translatedOperands);
        }
        if (!this.containsCheckedException(this.method)) {
            return callExpr;
        }
        return translator.handleMethodCheckedExceptions(callExpr);
    }

    private boolean containsCheckedException(Method method) {
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions == null || exceptions.length == 0) {
            return false;
        }
        for (Class<?> clazz : exceptions) {
            if (RuntimeException.class.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

