/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.spi.annotation.Beta;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Beta
public interface GenericRecord {
    @Nonnull
    public Builder newBuilder();

    @Nonnull
    public Builder cloneWithBuilder();

    @Nonnull
    public Set<String> getFieldNames();

    @Nonnull
    public FieldType getFieldType(@Nonnull String var1);

    public boolean hasField(@Nonnull String var1);

    public boolean readBoolean(@Nonnull String var1);

    public byte readByte(@Nonnull String var1);

    public char readChar(@Nonnull String var1);

    public double readDouble(@Nonnull String var1);

    public float readFloat(@Nonnull String var1);

    public int readInt(@Nonnull String var1);

    public long readLong(@Nonnull String var1);

    public short readShort(@Nonnull String var1);

    @Nullable
    public String readUTF(@Nonnull String var1);

    @Nullable
    public GenericRecord readGenericRecord(@Nonnull String var1);

    @Nullable
    public boolean[] readBooleanArray(@Nonnull String var1);

    @Nullable
    public byte[] readByteArray(@Nonnull String var1);

    @Nullable
    public char[] readCharArray(@Nonnull String var1);

    @Nullable
    public double[] readDoubleArray(@Nonnull String var1);

    @Nullable
    public float[] readFloatArray(@Nonnull String var1);

    @Nullable
    public int[] readIntArray(@Nonnull String var1);

    @Nullable
    public long[] readLongArray(@Nonnull String var1);

    @Nullable
    public short[] readShortArray(@Nonnull String var1);

    @Nullable
    public String[] readUTFArray(@Nonnull String var1);

    @Nullable
    public GenericRecord[] readGenericRecordArray(@Nonnull String var1);

    @Beta
    public static interface Builder {
        @Nonnull
        public static Builder portable(@Nonnull ClassDefinition classDefinition) {
            return new PortableGenericRecordBuilder(classDefinition);
        }

        @Nonnull
        public GenericRecord build();

        public Builder writeBoolean(@Nonnull String var1, boolean var2);

        public Builder writeByte(@Nonnull String var1, byte var2);

        public Builder writeChar(@Nonnull String var1, char var2);

        public Builder writeDouble(@Nonnull String var1, double var2);

        public Builder writeFloat(@Nonnull String var1, float var2);

        public Builder writeInt(@Nonnull String var1, int var2);

        public Builder writeLong(@Nonnull String var1, long var2);

        public Builder writeShort(@Nonnull String var1, short var2);

        public Builder writeUTF(@Nonnull String var1, @Nullable String var2);

        public Builder writeGenericRecord(@Nonnull String var1, @Nullable GenericRecord var2);

        public Builder writeBooleanArray(@Nonnull String var1, @Nullable boolean[] var2);

        public Builder writeByteArray(@Nonnull String var1, @Nullable byte[] var2);

        public Builder writeCharArray(@Nonnull String var1, @Nullable char[] var2);

        public Builder writeFloatArray(@Nonnull String var1, @Nullable float[] var2);

        public Builder writeIntArray(@Nonnull String var1, @Nullable int[] var2);

        public Builder writeDoubleArray(@Nonnull String var1, @Nullable double[] var2);

        public Builder writeLongArray(@Nonnull String var1, @Nullable long[] var2);

        public Builder writeShortArray(@Nonnull String var1, @Nullable short[] var2);

        public Builder writeUTFArray(@Nonnull String var1, @Nullable String[] var2);

        public Builder writeGenericRecordArray(@Nonnull String var1, @Nullable GenericRecord[] var2);
    }
}

