/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.futures;

import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Iterator;

public class ChainingFuture<T>
extends InternalCompletableFuture<T> {
    private final ExceptionHandler exceptionHandler;

    public ChainingFuture(Iterator<InternalCompletableFuture<T>> futuresToChain, ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        if (!futuresToChain.hasNext()) {
            this.complete(null);
        } else {
            InternalCompletableFuture<T> future = futuresToChain.next();
            this.registerCallback(future, futuresToChain);
        }
    }

    private void registerCallback(InternalCompletableFuture<T> future, Iterator<InternalCompletableFuture<T>> invocationIterator) {
        future.whenCompleteAsync((T response, U t) -> {
            if (t == null) {
                this.advanceOrComplete(response, invocationIterator);
            } else {
                try {
                    this.exceptionHandler.handle(t);
                    this.advanceOrComplete(null, invocationIterator);
                }
                catch (Throwable throwable) {
                    this.completeExceptionally((Throwable)t);
                }
            }
        });
    }

    private void advanceOrComplete(T response, Iterator<InternalCompletableFuture<T>> invocationIterator) {
        try {
            boolean hasNext = invocationIterator.hasNext();
            if (!hasNext) {
                this.complete(response);
            } else {
                InternalCompletableFuture<T> future = invocationIterator.next();
                this.registerCallback(future, invocationIterator);
            }
        }
        catch (Throwable t) {
            this.completeExceptionally(t);
        }
    }

    public static interface ExceptionHandler {
        public <T extends Throwable> void handle(T var1) throws T;
    }
}

