/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.impl.AbstractGenericRecord;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class PortableInternalGenericRecord
extends AbstractGenericRecord
implements InternalGenericRecord {
    protected final ClassDefinition cd;
    protected final PortableSerializer serializer;
    private final BufferObjectDataInput in;
    private final int offset;
    private final boolean readGenericLazy;
    private final int finalPosition;

    PortableInternalGenericRecord(PortableSerializer serializer, BufferObjectDataInput in, ClassDefinition cd, boolean readGenericLazy) {
        int fieldCount;
        this.in = in;
        this.serializer = serializer;
        this.cd = cd;
        this.readGenericLazy = readGenericLazy;
        try {
            this.finalPosition = in.readInt();
            fieldCount = in.readInt();
        }
        catch (IOException e) {
            throw new HazelcastSerializationException(e);
        }
        if (fieldCount != cd.getFieldCount()) {
            throw new IllegalStateException("Field count[" + fieldCount + "] in stream does not match " + cd);
        }
        this.offset = in.position();
    }

    public final void end() {
        this.in.position(this.finalPosition);
    }

    public ClassDefinition getClassDefinition() {
        return this.cd;
    }

    public int getVersion() {
        return this.cd.getVersion();
    }

    @Override
    public boolean hasField(@Nonnull String fieldName) {
        return this.cd.hasField(fieldName);
    }

    @Override
    @Nonnull
    public FieldType getFieldType(@Nonnull String fieldName) {
        return this.cd.getFieldType(fieldName);
    }

    @Override
    public boolean readBoolean(@Nonnull String fieldName) {
        try {
            return this.in.readBoolean(this.readPosition(fieldName, FieldType.BOOLEAN));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public byte readByte(@Nonnull String fieldName) {
        try {
            return this.in.readByte(this.readPosition(fieldName, FieldType.BYTE));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public char readChar(@Nonnull String fieldName) {
        try {
            return this.in.readChar(this.readPosition(fieldName, FieldType.CHAR));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public double readDouble(@Nonnull String fieldName) {
        try {
            return this.in.readDouble(this.readPosition(fieldName, FieldType.DOUBLE));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public float readFloat(@Nonnull String fieldName) {
        try {
            return this.in.readFloat(this.readPosition(fieldName, FieldType.FLOAT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public int readInt(@Nonnull String fieldName) {
        try {
            return this.in.readInt(this.readPosition(fieldName, FieldType.INT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public long readLong(@Nonnull String fieldName) {
        try {
            return this.in.readLong(this.readPosition(fieldName, FieldType.LONG));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public short readShort(@Nonnull String fieldName) {
        try {
            return this.in.readShort(this.readPosition(fieldName, FieldType.SHORT));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public String readUTF(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF);
            this.in.position(pos);
            String string = this.in.readUTF();
            return string;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private boolean isNullOrEmpty(int pos) {
        return pos == -1;
    }

    @Override
    public boolean[] readBooleanArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BOOLEAN_ARRAY);
            if (this.isNullOrEmpty(position)) {
                boolean[] blArray = null;
                return blArray;
            }
            this.in.position(position);
            boolean[] blArray = this.in.readBooleanArray();
            return blArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public byte[] readByteArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                byte[] byArray = null;
                return byArray;
            }
            this.in.position(position);
            byte[] byArray = this.in.readByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public char[] readCharArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
            if (this.isNullOrEmpty(position)) {
                char[] cArray = null;
                return cArray;
            }
            this.in.position(position);
            char[] cArray = this.in.readCharArray();
            return cArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public double[] readDoubleArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
            if (this.isNullOrEmpty(position)) {
                double[] dArray = null;
                return dArray;
            }
            this.in.position(position);
            double[] dArray = this.in.readDoubleArray();
            return dArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public float[] readFloatArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                float[] fArray = null;
                return fArray;
            }
            this.in.position(position);
            float[] fArray = this.in.readFloatArray();
            return fArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public int[] readIntArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.INT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                int[] nArray = null;
                return nArray;
            }
            this.in.position(position);
            int[] nArray = this.in.readIntArray();
            return nArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public long[] readLongArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.LONG_ARRAY);
            if (this.isNullOrEmpty(position)) {
                long[] lArray = null;
                return lArray;
            }
            this.in.position(position);
            long[] lArray = this.in.readLongArray();
            return lArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public short[] readShortArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
            if (this.isNullOrEmpty(position)) {
                short[] sArray = null;
                return sArray;
            }
            this.in.position(position);
            short[] sArray = this.in.readShortArray();
            return sArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public String[] readUTFArray(@Nonnull String fieldName) {
        int currentPos = this.in.position();
        try {
            int position = this.readPosition(fieldName, FieldType.UTF_ARRAY);
            if (this.isNullOrEmpty(position)) {
                String[] stringArray = null;
                return stringArray;
            }
            this.in.position(position);
            String[] stringArray = this.in.readUTFArray();
            return stringArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private void checkFactoryAndClass(FieldDefinition fd, int factoryId, int classId) {
        if (factoryId != fd.getFactoryId()) {
            throw new IllegalArgumentException("Invalid factoryId! Expected: " + fd.getFactoryId() + ", Current: " + factoryId);
        }
        if (classId != fd.getClassId()) {
            throw new IllegalArgumentException("Invalid classId! Expected: " + fd.getClassId() + ", Current: " + classId);
        }
    }

    private int readPosition(String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.cd.getField(fieldName);
        if (fd == null) {
            throw this.throwUnknownFieldException(fieldName);
        }
        if (fd.getType() != fieldType) {
            throw new HazelcastSerializationException("Not a '" + (Object)((Object)fieldType) + "' field: " + fieldName);
        }
        return this.readPosition(fd);
    }

    private IllegalStateException illegalStateException(IOException e) {
        return new IllegalStateException("IOException is not expected since we read from a well known format and position");
    }

    private HazelcastSerializationException throwUnknownFieldException(String fieldName) {
        return new HazelcastSerializationException("Unknown field name: '" + fieldName + "' for ClassDefinition {id: " + this.cd.getClassId() + ", version: " + this.cd.getVersion() + "}");
    }

    private int readPosition(FieldDefinition fd) {
        try {
            int pos = this.in.readInt(this.offset + fd.getIndex() * 4);
            short len = this.in.readShort(pos);
            return pos + 2 + len + 1;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    @Nonnull
    public GenericRecord.Builder newBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public GenericRecord.Builder cloneWithBuilder() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<String> getFieldNames() {
        return this.cd.getFieldNames();
    }

    @Override
    public GenericRecord[] readGenericRecordArray(@Nonnull String fieldName) {
        return (GenericRecord[])this.readNestedArray(fieldName, GenericRecord[]::new, false);
    }

    private <T> T[] readNestedArray(String fieldName, Function<Integer, T[]> constructor, boolean asPortable) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            if (this.isNullOrEmpty(position)) {
                T[] TArray = null;
                return TArray;
            }
            this.in.position(position);
            int len = this.in.readInt();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            if (len == -1) {
                T[] TArray = null;
                return TArray;
            }
            this.checkFactoryAndClass(fd, factoryId, classId);
            T[] portables = constructor.apply(len);
            if (len > 0) {
                int offset = this.in.position();
                for (int i = 0; i < len; ++i) {
                    int start = this.in.readInt(offset + i * 4);
                    this.in.position(start);
                    portables[i] = asPortable ? this.serializer.readAsObject(this.in, factoryId, classId) : this.serializer.readAndInitialize(this.in, factoryId, classId, this.readGenericLazy);
                }
            }
            T[] TArray = portables;
            return TArray;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public GenericRecord readGenericRecord(@Nonnull String fieldName) {
        return (GenericRecord)this.readNested(fieldName, false);
    }

    private <T> T readNested(String fieldName, boolean asPortable) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE) {
                throw new HazelcastSerializationException("Not a Portable field: " + fieldName);
            }
            int pos = this.readPosition(fd);
            this.in.position(pos);
            boolean isNull = this.in.readBoolean();
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            if (!isNull) {
                if (asPortable) {
                    Object t = this.serializer.readAsObject(this.in, factoryId, classId);
                    return t;
                }
                Object t = this.serializer.readAndInitialize(this.in, factoryId, classId, this.readGenericLazy);
                return t;
            }
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    private boolean doesNotHaveIndex(int beginPosition, int index) {
        try {
            int numberOfItems = this.in.readInt(beginPosition);
            return numberOfItems <= index;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Byte readByteFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.BYTE_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readByte(4 + position + index * 1);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public Boolean readBooleanFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.BOOLEAN_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readBoolean(4 + position + index * 1);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Character readCharFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.CHAR_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return Character.valueOf(this.in.readChar(4 + position + index * 2));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Double readDoubleFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.DOUBLE_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readDouble(4 + position + index * 8);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Float readFloatFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.FLOAT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return Float.valueOf(this.in.readFloat(4 + position + index * 4));
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Integer readIntFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.INT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readInt(4 + position + index * 4);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Long readLongFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.LONG_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readLong(4 + position + index * 8);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public Short readShortFromArray(String fieldName, int index) {
        int position = this.readPosition(fieldName, FieldType.SHORT_ARRAY);
        if (this.isNullOrEmpty(position) || this.doesNotHaveIndex(position, index)) {
            return null;
        }
        try {
            return this.in.readShort(4 + position + index * 2);
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
    }

    @Override
    public String readUTFFromArray(String fieldName, int index) {
        int currentPos = this.in.position();
        try {
            int pos = this.readPosition(fieldName, FieldType.UTF_ARRAY);
            this.in.position(pos);
            int length = this.in.readInt();
            if (length <= index) {
                String string = null;
                return string;
            }
            if (this.isNullOrEmpty(pos)) {
                String string = null;
                return string;
            }
            for (int i = 0; i < index; ++i) {
                int itemLength = this.in.readInt();
                if (itemLength <= 0) continue;
                this.in.position(this.in.position() + itemLength);
            }
            String string = this.in.readUTF();
            return string;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public GenericRecord readGenericRecordFromArray(String fieldName, int index) {
        return (GenericRecord)this.readNestedFromArray(fieldName, index, false);
    }

    @Override
    public Object readObjectFromArray(String fieldName, int index) {
        return this.readNestedFromArray(fieldName, index, true);
    }

    private <T> T readNestedFromArray(String fieldName, int index, boolean asPortable) {
        int currentPos = this.in.position();
        try {
            FieldDefinition fd = this.cd.getField(fieldName);
            if (fd == null) {
                throw this.throwUnknownFieldException(fieldName);
            }
            if (fd.getType() != FieldType.PORTABLE_ARRAY) {
                throw new HazelcastSerializationException("Not a Portable array field: " + fieldName);
            }
            int position = this.readPosition(fd);
            if (this.isNullOrEmpty(position)) {
                T t = null;
                return t;
            }
            this.in.position(position);
            int len = this.in.readInt();
            if (len == -1 || len == 0 || len <= index) {
                T t = null;
                return t;
            }
            int factoryId = this.in.readInt();
            int classId = this.in.readInt();
            this.checkFactoryAndClass(fd, factoryId, classId);
            int offset = this.in.position();
            int start = this.in.readInt(offset + index * 4);
            this.in.position(start);
            if (asPortable) {
                Object t = this.serializer.readAsObject(this.in, factoryId, classId);
                return t;
            }
            Object t = this.serializer.readAndInitialize(this.in, factoryId, classId, this.readGenericLazy);
            return t;
        }
        catch (IOException e) {
            throw this.illegalStateException(e);
        }
        finally {
            this.in.position(currentPos);
        }
    }

    @Override
    public Object[] readObjectArray(String fieldName) {
        return this.readNestedArray(fieldName, Portable[]::new, true);
    }

    @Override
    public Object readObject(String fieldName) {
        return this.readNested(fieldName, true);
    }

    @Override
    protected Object getClassIdentifier() {
        return this.cd;
    }
}

