/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;

public abstract class AbstractBasicConfig<T extends AbstractBasicConfig>
implements IdentifiedDataSerializable,
NamedConfig {
    protected String name;
    protected String splitBrainProtectionName;
    protected MergePolicyConfig mergePolicyConfig = new MergePolicyConfig();

    protected AbstractBasicConfig() {
    }

    protected AbstractBasicConfig(String name) {
        this.name = name;
    }

    protected AbstractBasicConfig(AbstractBasicConfig config) {
        this.name = config.name;
        this.splitBrainProtectionName = config.splitBrainProtectionName;
        this.mergePolicyConfig = config.mergePolicyConfig;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = Preconditions.checkNotNull(name, "name cannot be null");
        return (T)this;
    }

    public MergePolicyConfig getMergePolicyConfig() {
        return this.mergePolicyConfig;
    }

    public T setMergePolicyConfig(MergePolicyConfig mergePolicyConfig) {
        this.mergePolicyConfig = Preconditions.checkNotNull(mergePolicyConfig, "mergePolicyConfig cannot be null");
        return (T)this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public T setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", splitBrainProtectionName=" + this.splitBrainProtectionName + ", mergePolicyConfig=" + this.mergePolicyConfig + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }
}

