/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.ascii.AbstractTextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "MS_MUTABLE_ARRAY", "MS_PKGPROTECT"})
public abstract class HttpCommand
extends AbstractTextCommand {
    public static final byte[] CONTENT_TYPE_PLAIN_TEXT = StringUtil.stringToBytes("text/plain");
    public static final byte[] CONTENT_TYPE_JSON = StringUtil.stringToBytes("application/json");
    public static final byte[] CONTENT_TYPE_BINARY = StringUtil.stringToBytes("application/binary");
    public static final byte[] RES_200 = StringUtil.stringToBytes("HTTP/1.1 200 OK\r\n");
    public static final byte[] RES_400 = StringUtil.stringToBytes("HTTP/1.1 400 Bad Request\r\n");
    public static final byte[] RES_403 = StringUtil.stringToBytes("HTTP/1.1 403 Forbidden\r\n");
    public static final byte[] RES_404 = StringUtil.stringToBytes("HTTP/1.1 404 Not Found\r\n");
    public static final byte[] RES_100 = StringUtil.stringToBytes("HTTP/1.1 100 Continue\r\n\r\n");
    public static final byte[] RES_204 = StringUtil.stringToBytes("HTTP/1.1 204 No Content\r\n");
    public static final byte[] RES_503 = StringUtil.stringToBytes("HTTP/1.1 503 Service Unavailable\r\n");
    public static final byte[] RES_500 = StringUtil.stringToBytes("HTTP/1.1 500 Internal Server Error\r\n");
    static final String HEADER_CONTENT_TYPE = "content-type: ";
    static final String HEADER_CONTENT_LENGTH = "content-length: ";
    static final String HEADER_CHUNKED = "transfer-encoding: chunked";
    static final String HEADER_EXPECT_100 = "expect: 100";
    private static final String HEADER_CUSTOM_PREFIX = "Hazelcast-";
    private static final byte[] CONTENT_TYPE = StringUtil.stringToBytes("Content-Type: ");
    private static final byte[] CONTENT_LENGTH = StringUtil.stringToBytes("Content-Length: ");
    protected final String uri;
    protected ByteBuffer response;
    protected boolean nextLine;

    public HttpCommand(TextCommandConstants.TextCommandType type, String uri) {
        super(type);
        this.uri = uri;
        this.nextLine = true;
    }

    @Override
    public boolean shouldReply() {
        return true;
    }

    public String getURI() {
        return this.uri;
    }

    public void send204() {
        this.setResponse(RES_204, null, null);
    }

    public void send400() {
        this.setResponse(RES_400, null, null);
    }

    public void send403() {
        this.setResponse(RES_403, null, null);
    }

    public void send404() {
        this.setResponse(RES_404, null, null);
    }

    public void send500() {
        this.setResponse(RES_500, null, null);
    }

    public void send503() {
        this.setResponse(RES_503, null, null);
    }

    public void send200() {
        this.setResponse(RES_200, null, null);
    }

    public void setResponse(@Nonnull byte[] statusLine, @Nullable Map<String, Object> headers) {
        int size = statusLine.length;
        byte[] len = StringUtil.stringToBytes(String.valueOf(0));
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += TextCommandConstants.RETURN.length;
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                size += StringUtil.stringToBytes(HEADER_CUSTOM_PREFIX + entry.getKey() + ": ").length;
                size += StringUtil.stringToBytes(entry.getValue().toString()).length;
                size += TextCommandConstants.RETURN.length;
            }
        }
        this.response = ByteBuffer.allocate(size += TextCommandConstants.RETURN.length);
        this.response.put(statusLine);
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(TextCommandConstants.RETURN);
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                this.response.put(StringUtil.stringToBytes(HEADER_CUSTOM_PREFIX + entry.getKey() + ": "));
                this.response.put(StringUtil.stringToBytes(entry.getValue().toString()));
                this.response.put(TextCommandConstants.RETURN);
            }
        }
        this.response.put(TextCommandConstants.RETURN);
        this.response.flip();
    }

    public void setResponse(@Nonnull byte[] statusLine, @Nullable byte[] contentType, @Nullable byte[] value) {
        int valueSize = value == null ? 0 : value.length;
        byte[] len = StringUtil.stringToBytes(String.valueOf(valueSize));
        int size = statusLine.length;
        if (contentType != null) {
            size += CONTENT_TYPE.length;
            size += contentType.length;
            size += TextCommandConstants.RETURN.length;
        }
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += TextCommandConstants.RETURN.length;
        size += TextCommandConstants.RETURN.length;
        this.response = ByteBuffer.allocate(size += valueSize);
        this.response.put(statusLine);
        if (contentType != null) {
            this.response.put(CONTENT_TYPE);
            this.response.put(contentType);
            this.response.put(TextCommandConstants.RETURN);
        }
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(TextCommandConstants.RETURN);
        this.response.put(TextCommandConstants.RETURN);
        if (value != null) {
            this.response.put(value);
        }
        this.response.flip();
    }

    @Override
    public boolean writeTo(ByteBuffer dst) {
        IOUtil.copyToHeapBuffer(this.response, dst);
        return !this.response.hasRemaining();
    }

    @Override
    public boolean readFrom(ByteBuffer src) {
        while (src.hasRemaining()) {
            char c = (char)src.get();
            if (c == '\n') {
                if (this.nextLine) {
                    return true;
                }
                this.nextLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.nextLine = false;
        }
        return false;
    }

    @Override
    public String toString() {
        return "HttpCommand [" + (Object)((Object)this.type) + "]{uri='" + this.uri + '\'' + '}' + super.toString();
    }
}

