/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.distributed;

import com.hazelcast.hibernate.serialization.Expirable;
import com.hazelcast.hibernate.serialization.ExpiryMarker;
import com.hazelcast.hibernate.serialization.HibernateDataSerializerHook;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;

public class LockEntryProcessor
implements EntryProcessor<Object, Expirable, Expirable>,
IdentifiedDataSerializable {
    private String nextMarkerId;
    private long timeout;
    private Object version;

    public LockEntryProcessor() {
    }

    public LockEntryProcessor(String nextMarkerId, long timeout, Object version) {
        this.nextMarkerId = nextMarkerId;
        this.timeout = timeout;
        this.version = version;
    }

    @Override
    public Expirable process(Map.Entry<Object, Expirable> entry) {
        Expirable expirable = entry.getValue();
        expirable = expirable == null ? new ExpiryMarker(this.version, this.timeout, this.nextMarkerId) : expirable.markForExpiration(this.timeout, this.nextMarkerId);
        entry.setValue(expirable);
        return expirable;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.nextMarkerId);
        out.writeLong(this.timeout);
        out.writeObject(this.version);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nextMarkerId = in.readUTF();
        this.timeout = in.readLong();
        this.version = in.readObject();
    }

    @Override
    public int getFactoryId() {
        return HibernateDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }
}

