/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MembersUpdateOp
extends AbstractClusterOperation {
    long masterTime = Clock.currentTimeMillis();
    private List<MemberInfo> memberInfos;
    private UUID targetUuid;
    private boolean returnResponse;
    private PartitionRuntimeState partitionRuntimeState;
    private int memberListVersion;

    public MembersUpdateOp() {
        this.memberInfos = Collections.emptyList();
    }

    public MembersUpdateOp(UUID targetUuid, MembersView membersView, long masterTime, PartitionRuntimeState partitionRuntimeState, boolean returnResponse) {
        this.targetUuid = targetUuid;
        this.masterTime = masterTime;
        this.memberInfos = membersView.getMembers();
        this.returnResponse = returnResponse;
        this.partitionRuntimeState = partitionRuntimeState;
        this.memberListVersion = membersView.getVersion();
    }

    @Override
    public void run() throws Exception {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address callerAddress = this.getConnectionEndpointOrThisAddress();
        UUID callerUuid = this.getCallerUuid();
        if (clusterService.updateMembers(this.getMembersView(), callerAddress, callerUuid, this.targetUuid)) {
            this.processPartitionState();
        }
    }

    final int getMemberListVersion() {
        return this.memberListVersion;
    }

    final MembersView getMembersView() {
        return new MembersView(this.getMemberListVersion(), Collections.unmodifiableList(this.memberInfos));
    }

    final UUID getTargetUuid() {
        return this.targetUuid;
    }

    final Address getConnectionEndpointOrThisAddress() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Node node = nodeEngine.getNode();
        Connection conn = this.getConnection();
        return conn != null ? conn.getEndPoint() : node.getThisAddress();
    }

    final void processPartitionState() {
        if (this.partitionRuntimeState == null) {
            return;
        }
        this.partitionRuntimeState.setMaster(this.getCallerAddress());
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Node node = clusterService.getNodeEngine().getNode();
        node.partitionService.processPartitionRuntimeState(this.partitionRuntimeState);
    }

    @Override
    public final boolean returnsResponse() {
        return this.returnResponse;
    }

    protected void readInternalImpl(ObjectDataInput in) throws IOException {
        this.targetUuid = UUIDSerializationUtil.readUUID(in);
        this.masterTime = in.readLong();
        this.memberInfos = SerializationUtil.readList(in);
        this.partitionRuntimeState = (PartitionRuntimeState)in.readObject();
        this.returnResponse = in.readBoolean();
    }

    @Override
    protected final void readInternal(ObjectDataInput in) throws IOException {
        this.readInternalImpl(in);
        this.memberListVersion = in.readInt();
    }

    protected void writeInternalImpl(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.targetUuid);
        out.writeLong(this.masterTime);
        SerializationUtil.writeList(this.memberInfos, out);
        out.writeObject(this.partitionRuntimeState);
        out.writeBoolean(this.returnResponse);
    }

    @Override
    protected final void writeInternal(ObjectDataOutput out) throws IOException {
        this.writeInternalImpl(out);
        out.writeInt(this.memberListVersion);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", targetUuid=").append(this.targetUuid);
        sb.append(", members=");
        for (MemberInfo address : this.memberInfos) {
            sb.append(address).append(' ');
        }
    }

    @Override
    public int getClassId() {
        return 6;
    }
}

