/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class CacheRemoveCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1250816;
    public static final int RESPONSE_MESSAGE_TYPE = 1250817;
    private static final int REQUEST_COMPLETION_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private CacheRemoveCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, @Nullable Data currentValue, int completionId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Cache.Remove");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1250816);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, completionId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        CodecUtil.encodeNullable(clientMessage, currentValue, DataCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.completionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        request.key = DataCodec.decode(iterator);
        request.currentValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(boolean response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1250817);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public boolean response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        @Nullable
        public Data currentValue;
        public int completionId;
    }
}

