/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal;

import com.hazelcast.client.cp.internal.datastructures.proxy.ClientRaftProxyFactory;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.internal.util.Preconditions;
import javax.annotation.Nonnull;

public class CPSubsystemImpl
implements CPSubsystem {
    private final ClientRaftProxyFactory proxyFactory;

    public CPSubsystemImpl(HazelcastClientInstanceImpl client) {
        this.proxyFactory = new ClientRaftProxyFactory(client);
    }

    public void init(ClientContext context) {
        this.proxyFactory.init(context);
    }

    @Override
    @Nonnull
    public IAtomicLong getAtomicLong(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic long instance with a null name is not allowed!");
        return (IAtomicLong)this.proxyFactory.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    @Nonnull
    public <E> IAtomicReference<E> getAtomicReference(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic reference instance with a null name is not allowed!");
        return (IAtomicReference)this.proxyFactory.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    @Nonnull
    public ICountDownLatch getCountDownLatch(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a count down latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.proxyFactory.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    @Nonnull
    public FencedLock getLock(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an fenced lock instance with a null name is not allowed!");
        return (FencedLock)this.proxyFactory.createProxy("hz:raft:lockService", name);
    }

    @Override
    @Nonnull
    public ISemaphore getSemaphore(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.proxyFactory.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        throw new UnsupportedOperationException();
    }
}

