/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.spinning.SpinningChannelWriter;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SpinningOutputThread
extends Thread {
    private static final ChannelWriters SHUTDOWN = new ChannelWriters();
    private static final AtomicReferenceFieldUpdater<SpinningOutputThread, ChannelWriters> CONNECTION_HANDLERS = AtomicReferenceFieldUpdater.newUpdater(SpinningOutputThread.class, ChannelWriters.class, "channelWriters");
    private volatile ChannelWriters channelWriters = new ChannelWriters();

    SpinningOutputThread(String hzName) {
        super(ThreadUtil.createThreadName(hzName, "out-thread"));
    }

    void register(SpinningChannelWriter writer) {
        SpinningChannelWriter[] newWriters;
        ChannelWriters update;
        ChannelWriters current;
        do {
            if ((current = this.channelWriters) == SHUTDOWN) {
                return;
            }
            int length = current.writers.length;
            newWriters = new SpinningChannelWriter[length + 1];
            System.arraycopy(current.writers, 0, newWriters, 0, length);
            newWriters[length] = writer;
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new ChannelWriters(newWriters)));
    }

    void unregister(SpinningChannelWriter writer) {
        SpinningChannelWriter[] newWriters;
        ChannelWriters update;
        ChannelWriters current;
        do {
            if ((current = this.channelWriters) == SHUTDOWN) {
                return;
            }
            int indexOf = current.indexOf(writer);
            if (indexOf == -1) {
                return;
            }
            int length = current.writers.length;
            newWriters = new SpinningChannelWriter[length - 1];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                if (sourceIndex == indexOf) continue;
                newWriters[destIndex] = current.writers[sourceIndex];
                ++destIndex;
            }
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new ChannelWriters(newWriters)));
    }

    public void shutdown() {
        this.channelWriters = SHUTDOWN;
        this.interrupt();
    }

    @Override
    public void run() {
        ChannelWriters writers;
        block2: while ((writers = this.channelWriters) != SHUTDOWN) {
            SpinningChannelWriter[] spinningChannelWriterArray = writers.writers;
            int n = spinningChannelWriterArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                SpinningChannelWriter writer = spinningChannelWriterArray[n2];
                try {
                    writer.write();
                }
                catch (Throwable t) {
                    writer.onFailure(t);
                }
                ++n2;
            }
            break;
        }
        return;
    }

    private static class ChannelWriters {
        final SpinningChannelWriter[] writers;

        ChannelWriters() {
            this(new SpinningChannelWriter[0]);
        }

        ChannelWriters(SpinningChannelWriter[] writers) {
            this.writers = writers;
        }

        public int indexOf(SpinningChannelWriter handler) {
            for (int k = 0; k < this.writers.length; ++k) {
                if (this.writers[k] != handler) continue;
                return k;
            }
            return -1;
        }
    }
}

