/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.NonFragmentedServiceNamespace;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.operation.BaseMigrationDestinationOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public final class LegacyMigrationOperation
extends BaseMigrationDestinationOperation {
    private long[] replicaVersions;
    private Collection<Operation> tasks;

    public LegacyMigrationOperation() {
    }

    public LegacyMigrationOperation(MigrationInfo migrationInfo, long[] replicaVersions, Collection<Operation> tasks, int partitionStateVersion) {
        super(migrationInfo, partitionStateVersion);
        this.replicaVersions = replicaVersions;
        this.tasks = tasks;
    }

    @Override
    public void run() throws Exception {
        this.verifyMasterOnMigrationDestination();
        this.setActiveMigration();
        try {
            this.doRun();
        }
        catch (Throwable t) {
            this.logMigrationFailure(t);
            this.success = false;
            this.failureReason = t;
        }
        finally {
            this.onMigrationComplete();
            if (!this.success) {
                this.onExecutionFailure(this.failureReason);
            }
        }
    }

    private void doRun() throws Exception {
        if (this.migrationInfo.startProcessing()) {
            try {
                this.executeBeforeMigrations();
                for (Operation op : this.tasks) {
                    this.runMigrationOperation(op);
                }
                this.success = true;
            }
            catch (Throwable e) {
                this.success = false;
                this.failureReason = e;
                this.getLogger().severe("Error while executing replication operations " + this.migrationInfo, e);
            }
            finally {
                this.afterMigrate();
            }
        } else {
            this.success = false;
            this.logMigrationCancelled();
        }
    }

    private void afterMigrate() {
        if (this.success) {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            PartitionReplicaManager replicaManager = partitionService.getReplicaManager();
            int destinationNewReplicaIndex = this.migrationInfo.getDestinationNewReplicaIndex();
            int replicaOffset = destinationNewReplicaIndex <= 1 ? 1 : destinationNewReplicaIndex;
            replicaManager.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), NonFragmentedServiceNamespace.INSTANCE, this.replicaVersions, replicaOffset);
            if (this.getLogger().isFinestEnabled()) {
                this.getLogger().finest("ReplicaVersions are set after migration. partitionId=" + this.migrationInfo.getPartitionId() + " replicaVersions=" + Arrays.toString(this.replicaVersions));
            }
        } else if (this.getLogger().isFinestEnabled()) {
            this.getLogger().finest("ReplicaVersions are not set since migration failed. partitionId=" + this.migrationInfo.getPartitionId());
        }
        this.migrationInfo.doneProcessing();
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.tasks != null) {
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLongArray(this.replicaVersions);
        int size = this.tasks != null ? this.tasks.size() : 0;
        out.writeInt(size);
        if (size > 0) {
            for (Operation task : this.tasks) {
                out.writeObject(task);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.replicaVersions = in.readLongArray();
        int size = in.readInt();
        if (size > 0) {
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation op = (Operation)in.readObject();
                this.tasks.add(op);
            }
        } else {
            this.tasks = Collections.emptyList();
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        int numberOfTasks = this.tasks == null ? 0 : this.tasks.size();
        sb.append(", migration=").append(this.migrationInfo);
        sb.append(", replicaVersions=").append(Arrays.toString(this.replicaVersions));
        sb.append(", numberOfTasks=").append(numberOfTasks);
    }

    @Override
    public int getId() {
        return 7;
    }
}

