/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.spinning.SpinningChannelReader;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SpinningInputThread
extends Thread {
    private static final ChannelReaders SHUTDOWN = new ChannelReaders();
    private static final AtomicReferenceFieldUpdater<SpinningInputThread, ChannelReaders> CONNECTION_HANDLERS = AtomicReferenceFieldUpdater.newUpdater(SpinningInputThread.class, ChannelReaders.class, "channelReaders");
    private volatile ChannelReaders channelReaders = new ChannelReaders();

    SpinningInputThread(String hzName) {
        super(ThreadUtil.createThreadName(hzName, "in-thread"));
    }

    void register(SpinningChannelReader reader) {
        SpinningChannelReader[] newReaders;
        ChannelReaders update;
        ChannelReaders current;
        do {
            if ((current = this.channelReaders) == SHUTDOWN) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningChannelReader[length + 1];
            System.arraycopy(current.readers, 0, newReaders, 0, length);
            newReaders[length] = reader;
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new ChannelReaders(newReaders)));
    }

    void unregister(SpinningChannelReader reader) {
        SpinningChannelReader[] newReaders;
        ChannelReaders update;
        ChannelReaders current;
        do {
            if ((current = this.channelReaders) == SHUTDOWN) {
                return;
            }
            int indexOf = current.indexOf(reader);
            if (indexOf == -1) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningChannelReader[length - 1];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                if (sourceIndex == indexOf) continue;
                newReaders[destIndex] = current.readers[sourceIndex];
                ++destIndex;
            }
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new ChannelReaders(newReaders)));
    }

    public void shutdown() {
        this.channelReaders = SHUTDOWN;
        this.interrupt();
    }

    @Override
    public void run() {
        ChannelReaders readers;
        block2: while ((readers = this.channelReaders) != SHUTDOWN) {
            SpinningChannelReader[] spinningChannelReaderArray = readers.readers;
            int n = spinningChannelReaderArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                SpinningChannelReader reader = spinningChannelReaderArray[n2];
                try {
                    reader.read();
                }
                catch (Throwable t) {
                    reader.onFailure(t);
                }
                ++n2;
            }
            break;
        }
        return;
    }

    static class ChannelReaders {
        final SpinningChannelReader[] readers;

        ChannelReaders() {
            this(new SpinningChannelReader[0]);
        }

        ChannelReaders(SpinningChannelReader[] readers) {
            this.readers = readers;
        }

        public int indexOf(SpinningChannelReader reader) {
            for (int k = 0; k < this.readers.length; ++k) {
                if (this.readers[k] != reader) continue;
                return k;
            }
            return -1;
        }
    }
}

