/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.util.ClientMessageReadHandler;
import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ClientReadHandler
implements ReadHandler,
ClientMessageReadHandler.MessageHandler {
    private final ClientMessageReadHandler readHandler;
    private final Connection connection;
    private final IOService ioService;

    public ClientReadHandler(SwCounter messageCounter, Connection connection, IOService ioService) throws IOException {
        this.connection = connection;
        this.ioService = ioService;
        this.readHandler = new ClientMessageReadHandler(messageCounter, this);
    }

    @Override
    public void onRead(ByteBuffer src) throws Exception {
        this.readHandler.onRead(src);
    }

    @Override
    public void handleMessage(ClientMessage message) {
        this.ioService.handleClientMessage(message, this.connection);
    }
}

