/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.impl.CallIdSequence;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientInvocationFuture
extends AbstractInvocationFuture<ClientMessage> {
    private final ClientMessage request;
    private final ClientInvocation invocation;
    private final CallIdSequence callIdSequence;

    public ClientInvocationFuture(ClientInvocation invocation, Executor internalExecutor, ClientMessage request, ILogger logger, CallIdSequence callIdSequence) {
        super(internalExecutor, logger);
        this.request = request;
        this.invocation = invocation;
        this.callIdSequence = callIdSequence;
    }

    @Override
    protected String invocationToString() {
        return this.request.toString();
    }

    @Override
    protected void onInterruptDetected() {
        this.complete(new InterruptedException());
    }

    @Override
    protected TimeoutException newTimeoutException(long timeout, TimeUnit unit) {
        return new TimeoutException();
    }

    @Override
    protected Throwable unwrap(Throwable throwable) {
        return throwable;
    }

    @Override
    protected Object resolve(Object value) {
        if (value instanceof Throwable) {
            return new ExecutionException((Throwable)value);
        }
        return value;
    }

    @Override
    public void andThen(ExecutionCallback<ClientMessage> callback) {
        super.andThen(new InternalDelegatingExecutionCallback(callback));
    }

    @Override
    public void andThen(ExecutionCallback<ClientMessage> callback, Executor executor) {
        super.andThen(new InternalDelegatingExecutionCallback(callback), executor);
    }

    @Override
    protected void onComplete() {
        this.callIdSequence.complete();
    }

    @Override
    public ClientMessage resolveAndThrowIfException(Object response) throws ExecutionException, InterruptedException {
        if (response instanceof Throwable) {
            ExceptionUtil.fixAsyncStackTrace((Throwable)response, Thread.currentThread().getStackTrace());
            if (response instanceof ExecutionException) {
                throw (ExecutionException)response;
            }
            if (response instanceof Error) {
                throw (Error)response;
            }
            if (response instanceof InterruptedException) {
                throw (InterruptedException)response;
            }
            if (response instanceof CancellationException) {
                throw (CancellationException)response;
            }
            throw new ExecutionException((Throwable)response);
        }
        return (ClientMessage)response;
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    class InternalDelegatingExecutionCallback
    implements ExecutionCallback<ClientMessage> {
        private final ExecutionCallback<ClientMessage> callback;

        InternalDelegatingExecutionCallback(ExecutionCallback<ClientMessage> callback) {
            this.callback = callback;
            ClientInvocationFuture.this.callIdSequence.forceNext();
        }

        @Override
        public void onResponse(ClientMessage message) {
            try {
                this.callback.onResponse(message);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }

        @Override
        public void onFailure(Throwable t) {
            try {
                this.callback.onFailure(t);
            }
            finally {
                ClientInvocationFuture.this.callIdSequence.complete();
            }
        }
    }
}

