/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.NullQueryCache;
import com.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QueryCacheEndToEndProvider<K, V> {
    private static final int MUTEX_COUNT = 16;
    private static final int MASK = 15;
    private final Object[] mutexes = this.createMutexes();
    private final Map<String, Map<String, InternalQueryCache<K, V>>> mapNameToQueryCaches = new HashMap<String, Map<String, InternalQueryCache<K, V>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalQueryCache<K, V> getOrCreateQueryCache(String mapName, String cacheId, ConstructorFunction<String, InternalQueryCache<K, V>> constructor) {
        Object object = this.getMutex(mapName);
        synchronized (object) {
            InternalQueryCache<K, V> queryCache;
            Map<String, InternalQueryCache<String, InternalQueryCache<K, V>>> cacheIdToQueryCache = this.mapNameToQueryCaches.get(mapName);
            if (cacheIdToQueryCache == null) {
                cacheIdToQueryCache = new ConcurrentHashMap<String, InternalQueryCache<K, V>>();
                this.mapNameToQueryCaches.put(mapName, cacheIdToQueryCache);
            }
            if ((queryCache = cacheIdToQueryCache.get(cacheId)) == null) {
                queryCache = constructor.createNew(cacheId);
                if (queryCache == NullQueryCache.NULL_QUERY_CACHE) {
                    queryCache = null;
                } else {
                    cacheIdToQueryCache.put(cacheId, queryCache);
                }
            }
            return queryCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSingleQueryCache(String mapName, String cacheId) {
        Object object = this.getMutex(mapName);
        synchronized (object) {
            Map<String, InternalQueryCache<K, V>> cacheIdToQueryCache = this.mapNameToQueryCaches.get(mapName);
            if (cacheIdToQueryCache != null) {
                cacheIdToQueryCache.remove(cacheId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllQueryCaches(String mapName) {
        Object object = this.getMutex(mapName);
        synchronized (object) {
            Map<String, InternalQueryCache<K, V>> cacheIdToQueryCache = this.mapNameToQueryCaches.remove(mapName);
            if (cacheIdToQueryCache != null) {
                for (InternalQueryCache<K, V> queryCache : cacheIdToQueryCache.values()) {
                    queryCache.destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueryCacheCount(String mapName) {
        Object object = this.getMutex(mapName);
        synchronized (object) {
            Map<String, InternalQueryCache<K, V>> cacheIdToQueryCache = this.mapNameToQueryCaches.get(mapName);
            if (cacheIdToQueryCache == null) {
                return 0;
            }
            return cacheIdToQueryCache.size();
        }
    }

    private Object[] createMutexes() {
        Object[] mutexes = new Object[16];
        for (int i = 0; i < 16; ++i) {
            mutexes[i] = new Object();
        }
        return mutexes;
    }

    private Object getMutex(String name) {
        int hashCode = name.hashCode();
        if (hashCode == Integer.MIN_VALUE) {
            hashCode = 0;
        }
        hashCode = Math.abs(hashCode);
        return this.mutexes[hashCode & 0xF];
    }
}

