/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddIndexCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateCodec;
import com.hazelcast.client.impl.protocol.codec.MapAggregateWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntriesWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapEvictCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnAllKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteOnKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapExecuteWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapFlushCodec;
import com.hazelcast.client.impl.protocol.codec.MapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MapGetEntryViewCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.MapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapKeySetWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapLoadGivenKeysCodec;
import com.hazelcast.client.impl.protocol.codec.MapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectCodec;
import com.hazelcast.client.impl.protocol.codec.MapProjectWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutIfAbsentCodec;
import com.hazelcast.client.impl.protocol.codec.MapPutTransientCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveAllCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveInterceptorCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemovePartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceCodec;
import com.hazelcast.client.impl.protocol.codec.MapReplaceIfSameCodec;
import com.hazelcast.client.impl.protocol.codec.MapSetCodec;
import com.hazelcast.client.impl.protocol.codec.MapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MapSubmitToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryPutCodec;
import com.hazelcast.client.impl.protocol.codec.MapTryRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPagingPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.MapValuesWithPredicateCodec;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheEndToEndConstructor;
import com.hazelcast.client.map.impl.ClientMapPartitionIterator;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.AbstractIMapEvent;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapPartitionLostEvent;
import com.hazelcast.map.QueryCache;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.map.impl.MapListenerFlagOperator;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndProvider;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequests;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.collection.InflatableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_PREDICATE_IS_NOT_ALLOWED = "Predicate should not be null!";
    protected static final String NULL_AGGREGATOR_IS_NOT_ALLOWED = "Aggregator should not be null!";
    private static final ClientMessageDecoder GET_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder PUT_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapPutCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SET_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder REMOVE_ASYNC_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapRemoveCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SUBMIT_TO_KEY_RESPONSE_DECODER = new ClientMessageDecoder(){

        @Override
        public <T> T decodeClientMessage(ClientMessage clientMessage) {
            return (T)MapSubmitToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private ClientQueryCacheContext queryCacheContext;

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.lockReferenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
        this.queryCacheContext = this.getContext().getQueryCacheContext();
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.containsKeyInternal(keyData);
    }

    protected boolean containsKeyInternal(Data keyData) {
        ClientMessage message = MapContainsKeyCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage result = (ClientMessage)this.invoke(message, keyData);
        MapContainsKeyCodec.ResponseParameters resultParameters = MapContainsKeyCodec.decodeResponse(result);
        return resultParameters.response;
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = MapContainsValueCodec.encodeRequest(this.name, valueData);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapContainsValueCodec.ResponseParameters resultParameters = MapContainsValueCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return (V)this.toObject(this.getInternal(keyData));
    }

    protected Object getInternal(Data keyData) {
        ClientMessage request = MapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetCodec.ResponseParameters resultParameters = MapGetCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V remove(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MapRemoveCodec.ResponseParameters resultParameters = this.removeInternal(keyData);
        return (V)this.toObject(resultParameters.response);
    }

    protected MapRemoveCodec.ResponseParameters removeInternal(Data keyData) {
        ClientMessage request = MapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        return MapRemoveCodec.decodeResponse(response);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.removeInternal(keyData, valueData);
    }

    protected boolean removeInternal(Data keyData, Data valueData) {
        ClientMessage request = MapRemoveIfSameCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapRemoveIfSameCodec.ResponseParameters resultParameters = MapRemoveIfSameCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void removeAll(Predicate<K, V> predicate) {
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        this.removeAllInternal(predicate);
    }

    protected void removeAllInternal(Predicate predicate) {
        ClientMessage request = MapRemoveAllCodec.encodeRequest(this.name, this.toData(predicate));
        this.invoke(request);
    }

    @Override
    public void delete(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.deleteInternal(keyData);
    }

    protected void deleteInternal(Data keyData) {
        ClientMessage request = MapDeleteCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    public void flush() {
        ClientMessage request = MapFlushCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public ICompletableFuture<V> getAsync(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.getAsyncInternal(keyData);
    }

    protected ICompletableFuture<V> getAsyncInternal(Data keyData) {
        SerializationService serializationService = this.getContext().getSerializationService();
        ClientMessage request = MapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, serializationService, GET_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private ClientInvocationFuture invokeOnKeyOwner(ClientMessage request, Data keyData) {
        int partitionId = this.getContext().getPartitionService().getPartitionId(keyData);
        ClientInvocation clientInvocation = new ClientInvocation(this.getClient(), request, partitionId);
        return clientInvocation.invoke();
    }

    @Override
    public ICompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ICompletableFuture<V> putAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putAsyncInternal(ttl, timeunit, keyData, valueData);
    }

    protected ICompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), PUT_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public ICompletableFuture<Void> setAsync(K key, V value) {
        return this.setAsync((Object)key, (Object)value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ICompletableFuture<Void> setAsync(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.setAsyncInternal(ttl, timeunit, keyData, valueData);
    }

    protected ICompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapSetCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture<Void>(future, this.getContext().getSerializationService(), SET_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public ICompletableFuture<V> removeAsync(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.removeAsyncInternal(keyData);
    }

    protected ICompletableFuture<V> removeAsyncInternal(Data keyData) {
        ClientMessage request = MapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), REMOVE_ASYNC_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.tryRemoveInternal(timeout, timeunit, keyData);
    }

    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Data keyData) {
        ClientMessage request = MapTryRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryRemoveCodec.ResponseParameters resultParameters = MapTryRemoveCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.tryPutInternal(timeout, timeunit, keyData, valueData);
    }

    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapTryPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryPutCodec.ResponseParameters resultParameters = MapTryPutCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putInternal(ttl, timeunit, keyData, valueData);
    }

    protected V putInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapPutCodec.ResponseParameters resultParameters = MapPutCodec.decodeResponse(response);
        return (V)this.toObject(resultParameters.response);
    }

    @Override
    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.putTransientInternal(ttl, timeunit, keyData, valueData);
    }

    protected void putTransientInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapPutTransientCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.putIfAbsentInternal(ttl, timeunit, keyData, valueData);
    }

    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapPutIfAbsentCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        ClientMessage result = (ClientMessage)this.invoke(request, keyData);
        MapPutIfAbsentCodec.ResponseParameters resultParameters = MapPutIfAbsentCodec.decodeResponse(result);
        return (V)this.toObject(resultParameters.response);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(oldValue, NULL_VALUE_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(newValue, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        return this.replaceIfSameInternal(keyData, oldValueData, newValueData);
    }

    protected boolean replaceIfSameInternal(Data keyData, Data oldValueData, Data newValueData) {
        ClientMessage request = MapReplaceIfSameCodec.encodeRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceIfSameCodec.ResponseParameters resultParameters = MapReplaceIfSameCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public V replace(K key, V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        return this.replaceInternal(keyData, valueData);
    }

    protected V replaceInternal(Data keyData, Data valueData) {
        ClientMessage request = MapReplaceCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapReplaceCodec.ResponseParameters resultParameters = MapReplaceCodec.decodeResponse(response);
        return (V)this.toObject(resultParameters.response);
    }

    @Override
    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        this.setInternal(ttl, timeunit, keyData, valueData);
    }

    protected void setInternal(long ttl, TimeUnit timeunit, Data keyData, Data valueData) {
        ClientMessage request = MapSetCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    @Override
    public void lock(K key) {
        this.lock(key, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapIsLockedCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapIsLockedCodec.ResponseParameters resultParameters = MapIsLockedCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, Long.MAX_VALUE, null);
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit, long leaseTime, TimeUnit leaseUnit) throws InterruptedException {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(time, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = MapTryLockCodec.encodeRequest(this.name, keyData, threadId, leaseTimeInMillis, timeoutInMillis, this.lockReferenceIdGenerator.getNextReferenceId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapTryLockCodec.ResponseParameters resultParameters = MapTryLockCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void unlock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapUnlockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapForceUnlockCodec.encodeRequest(this.name, keyData, this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public String addLocalEntryListener(MapListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addLocalEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        Data data = this.toData(interceptor);
        ClientMessage request = MapAddInterceptorCodec.encodeRequest(this.name, data);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAddInterceptorCodec.ResponseParameters resultParameters = MapAddInterceptorCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void removeInterceptor(String id) {
        ClientMessage request = MapRemoveInterceptorCodec.encodeRequest(this.name, id);
        this.invoke(request);
    }

    @Override
    public String addEntryListener(MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter listenerAdaptor, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerCodec(includeValue, listenerFlags), handler);
    }

    private ListenerMessageCodec createMapEntryListenerCodec(final boolean includeValue, final int listenerFlags) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, includeValue, listenerFlags, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public String addPartitionLostListener(MapPartitionLostListener listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ClientMapPartitionLostEventHandler handler = new ClientMapPartitionLostEventHandler(listener);
        return this.registerListener(this.createMapPartitionListenerCodec(), handler);
    }

    private ListenerMessageCodec createMapPartitionListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddPartitionLostListenerCodec.encodeRequest(ClientMapProxy.this.name, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddPartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemovePartitionLostListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemovePartitionLostListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removePartitionLostListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public String addEntryListener(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, key, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, key, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter listenerAdaptor, K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createMapEntryListenerToKeyCodec(includeValue, listenerFlags, keyData), handler);
    }

    private ListenerMessageCodec createMapEntryListenerToKeyCodec(final boolean includeValue, final int listenerFlags, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyCodec.encodeRequest(ClientMapProxy.this.name, keyData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, predicate, key, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, predicate, key, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter listenerAdaptor, Predicate<K, V> predicate, K key, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        ListenerMessageCodec codec = this.createEntryListenerToKeyWithPredicateCodec(includeValue, listenerFlags, keyData, predicateData);
        return this.registerListener(codec, handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerToKeyWithPredicateCodec.encodeRequest(ClientMapProxy.this.name, keyData, predicateData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, predicate, includeValue);
    }

    @Override
    public String addEntryListener(EntryListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        return this.addEntryListenerInternal(listenerAdaptor, predicate, includeValue);
    }

    private String addEntryListenerInternal(ListenerAdapter listenerAdaptor, Predicate<K, V> predicate, boolean includeValue) {
        int listenerFlags = MapListenerFlagOperator.setAndGetListenerFlags(listenerAdaptor);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listenerAdaptor);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(includeValue, listenerFlags, predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final boolean includeValue, final int listenerFlags, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MapAddEntryListenerWithPredicateCodec.encodeRequest(ClientMapProxy.this.name, predicateData, includeValue, listenerFlags, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return MapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(ClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MapGetEntryViewCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapGetEntryViewCodec.ResponseParameters parameters = MapGetEntryViewCodec.decodeResponse(response);
        SimpleEntryView entryView = new SimpleEntryView();
        SimpleEntryView<Data, Data> dataEntryView = parameters.response;
        if (dataEntryView == null) {
            return null;
        }
        entryView.setKey(this.toObject(dataEntryView.getKey()));
        entryView.setValue(this.toObject(dataEntryView.getValue()));
        entryView.setCost(dataEntryView.getCost());
        entryView.setCreationTime(dataEntryView.getCreationTime());
        entryView.setExpirationTime(dataEntryView.getExpirationTime());
        entryView.setHits(dataEntryView.getHits());
        entryView.setLastAccessTime(dataEntryView.getLastAccessTime());
        entryView.setLastStoredTime(dataEntryView.getLastStoredTime());
        entryView.setLastUpdateTime(dataEntryView.getLastUpdateTime());
        entryView.setVersion(dataEntryView.getVersion());
        entryView.setHits(dataEntryView.getHits());
        entryView.setTtl(dataEntryView.getTtl());
        return entryView;
    }

    @Override
    public boolean evict(K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.evictInternal(keyData);
    }

    protected boolean evictInternal(Data keyData) {
        ClientMessage request = MapEvictCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapEvictCodec.ResponseParameters resultParameters = MapEvictCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void evictAll() {
        ClientMessage request = MapEvictAllCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        ClientMessage request = MapLoadAllCodec.encodeRequest(this.name, replaceExistingValues);
        this.invoke(request);
    }

    @Override
    public void loadAll(Set<K> keys, boolean replaceExistingValues) {
        Preconditions.checkNotNull(keys, "Parameter keys should not be null.");
        if (keys.isEmpty()) {
            return;
        }
        Collection<Data> dataKeys = CollectionUtil.objectToDataCollection(keys, this.getSerializationService());
        this.loadAllInternal(replaceExistingValues, dataKeys);
    }

    protected void loadAllInternal(boolean replaceExistingValues, Collection<Data> dataKeys) {
        ClientMessage request = MapLoadGivenKeysCodec.encodeRequest(this.name, dataKeys, replaceExistingValues);
        this.invoke(request);
    }

    @Override
    public Set<K> keySet() {
        ClientMessage request = MapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetCodec.ResponseParameters resultParameters = MapKeySetCodec.decodeResponse(response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder(resultParameters.response.size());
        for (Data data : resultParameters.response) {
            Object key = this.toObject(data);
            setBuilder.add(key);
        }
        return setBuilder.build();
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        if (CollectionUtil.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<Data>> partitionToKeyData = new HashMap<Integer, List<Data>>();
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        for (K key : keys) {
            Data keyData = this.toData(key);
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<Data> keyList = (ArrayList<Data>)partitionToKeyData.get(partitionId);
            if (keyList == null) {
                keyList = new ArrayList<Data>();
                partitionToKeyData.put(partitionId, keyList);
            }
            keyList.add(keyData);
        }
        HashMap result = new HashMap();
        this.getAllInternal(partitionToKeyData, result);
        return result;
    }

    protected List<MapGetAllCodec.ResponseParameters> getAllInternal(Map<Integer, List<Data>> partitionToKeyData, Map<K, V> result) {
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(partitionToKeyData.size());
        ArrayList<MapGetAllCodec.ResponseParameters> responses = new ArrayList<MapGetAllCodec.ResponseParameters>(partitionToKeyData.size());
        for (Map.Entry<Integer, List<Data>> entry : partitionToKeyData.entrySet()) {
            int partitionId = entry.getKey();
            List<Data> keyList = entry.getValue();
            if (keyList.isEmpty()) continue;
            ClientMessage request = MapGetAllCodec.encodeRequest(this.name, keyList);
            futures.add(new ClientInvocation(this.getClient(), request, partitionId).invoke());
        }
        for (Future future : futures) {
            try {
                ClientMessage response = (ClientMessage)future.get();
                MapGetAllCodec.ResponseParameters resultParameters = MapGetAllCodec.decodeResponse(response);
                for (Map.Entry<Data, Data> entry : resultParameters.response) {
                    Object value = this.toObject(entry.getValue());
                    Object key = this.toObject(entry.getKey());
                    result.put(key, value);
                }
                responses.add(resultParameters);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        return responses;
    }

    @Override
    public Collection<V> values() {
        ClientMessage request = MapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesCodec.ResponseParameters resultParameters = MapValuesCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntrySetCodec.ResponseParameters resultParameters = MapEntrySetCodec.decodeResponse(response);
        InflatableSet.Builder<LazyMapEntry> setBuilder = InflatableSet.newBuilder(resultParameters.response.size());
        InternalSerializationService serializationService = (InternalSerializationService)this.getContext().getSerializationService();
        for (Map.Entry<Data, Data> row : resultParameters.response) {
            LazyMapEntry entry = new LazyMapEntry(row.getKey(), row.getValue(), serializationService);
            setBuilder.add(entry);
        }
        return setBuilder.build();
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        if (predicate instanceof PagingPredicate) {
            return this.keySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapKeySetWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetWithPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPredicateCodec.decodeResponse(response);
        InflatableSet.Builder setBuilder = InflatableSet.newBuilder(resultParameters.response.size());
        for (Data data : resultParameters.response) {
            Object key = this.toObject(data);
            setBuilder.add(key);
        }
        return setBuilder.build();
    }

    private Set<K> keySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.KEY);
        ClientMessage request = MapKeySetWithPagingPredicateCodec.encodeRequest(this.name, this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapKeySetWithPagingPredicateCodec.ResponseParameters resultParameters = MapKeySetWithPagingPredicateCodec.decodeResponse(response);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        for (Data keyData : resultParameters.response) {
            Object key = this.toObject(keyData);
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, null));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, IterationType.KEY);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        if (predicate instanceof PagingPredicate) {
            return this.entrySetWithPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapEntriesWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntriesWithPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPredicateCodec.decodeResponse(response);
        InflatableSet.Builder<LazyMapEntry> setBuilder = InflatableSet.newBuilder(resultParameters.response.size());
        InternalSerializationService serializationService = (InternalSerializationService)this.getContext().getSerializationService();
        for (Map.Entry<Data, Data> row : resultParameters.response) {
            LazyMapEntry entry = new LazyMapEntry(row.getKey(), row.getValue(), serializationService);
            setBuilder.add(entry);
        }
        return setBuilder.build();
    }

    public Set<Map.Entry<K, V>> entrySetWithPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.ENTRY);
        ClientMessage request = MapEntriesWithPagingPredicateCodec.encodeRequest(this.name, this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapEntriesWithPagingPredicateCodec.ResponseParameters resultParameters = MapEntriesWithPagingPredicateCodec.decodeResponse(response);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>();
        for (Map.Entry<Data, Data> entry : resultParameters.response) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, IterationType.ENTRY);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        if (predicate instanceof PagingPredicate) {
            return this.valuesForPagingPredicate((PagingPredicate)predicate);
        }
        ClientMessage request = MapValuesWithPredicateCodec.encodeRequest(this.name, this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesWithPredicateCodec.ResponseParameters resultParameters = MapValuesWithPredicateCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    private Collection<V> valuesForPagingPredicate(PagingPredicate pagingPredicate) {
        pagingPredicate.setIterationType(IterationType.VALUE);
        ClientMessage request = MapValuesWithPagingPredicateCodec.encodeRequest(this.name, this.toData(pagingPredicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapValuesWithPagingPredicateCodec.ResponseParameters resultParameters = MapValuesWithPagingPredicateCodec.decodeResponse(response);
        ArrayList<Map.Entry> resultList = new ArrayList<Map.Entry>(resultParameters.response.size());
        for (Map.Entry<Data, Data> entry : resultParameters.response) {
            Object key = this.toObject(entry.getKey());
            Object value = this.toObject(entry.getValue());
            resultList.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        return SortingUtil.getSortedQueryResultSet(resultList, pagingPredicate, IterationType.VALUE);
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        ClientMessage request = MapAddIndexCodec.encodeRequest(this.name, attribute, ordered);
        this.invoke(request);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return new LocalMapStatsImpl();
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.executeOnKeyInternal(keyData, entryProcessor);
    }

    public Object executeOnKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        ClientMapProxy.validateEntryProcessorForSingleKeyProcessing(entryProcessor);
        ClientMessage request = MapExecuteOnKeyCodec.encodeRequest(this.name, this.toData(entryProcessor), keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MapExecuteOnKeyCodec.ResponseParameters resultParameters = MapExecuteOnKeyCodec.decodeResponse(response);
        return this.toObject(resultParameters.response);
    }

    private static void validateEntryProcessorForSingleKeyProcessing(EntryProcessor entryProcessor) {
        EntryBackupProcessor backupProcessor;
        if (entryProcessor instanceof ReadOnly && (backupProcessor = entryProcessor.getBackupProcessor()) != null) {
            throw new IllegalArgumentException("EntryProcessor.getBackupProcessor() should be null for a ReadOnly EntryProcessor");
        }
    }

    @Override
    public void submitToKey(K key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        this.submitToKeyInternal(keyData, entryProcessor, callback);
    }

    public void submitToKeyInternal(Data keyData, EntryProcessor entryProcessor, ExecutionCallback callback) {
        ClientMessage request = MapSubmitToKeyCodec.encodeRequest(this.name, this.toData(entryProcessor), keyData, ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            SerializationService serializationService = this.getContext().getSerializationService();
            ClientDelegatingFuture clientDelegatingFuture = new ClientDelegatingFuture(future, serializationService, SUBMIT_TO_KEY_RESPONSE_DECODER);
            clientDelegatingFuture.andThen(callback);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public ICompletableFuture submitToKey(K key, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        return this.submitToKeyInternal(keyData, entryProcessor);
    }

    public ICompletableFuture submitToKeyInternal(Data keyData, EntryProcessor entryProcessor) {
        ClientMessage request = MapSubmitToKeyCodec.encodeRequest(this.name, this.toData(entryProcessor), keyData, ThreadUtil.getThreadId());
        try {
            ClientInvocationFuture future = this.invokeOnKeyOwner(request, keyData);
            return new ClientDelegatingFuture(future, this.getContext().getSerializationService(), SUBMIT_TO_KEY_RESPONSE_DECODER);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        ClientMessage request = MapExecuteOnAllKeysCodec.encodeRequest(this.name, this.toData(entryProcessor));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnAllKeysCodec.ResponseParameters resultParameters = MapExecuteOnAllKeysCodec.decodeResponse(response);
        return this.prepareResult(resultParameters.response);
    }

    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entries) {
        if (CollectionUtil.isEmpty(entries)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entries.size());
        for (Map.Entry<Data, Data> entry : entries) {
            Object key = this.toObject(entry.getKey());
            result.put(key, this.toObject(entry.getValue()));
        }
        return result;
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor, Predicate predicate) {
        ClientMessage request = MapExecuteWithPredicateCodec.encodeRequest(this.name, this.toData(entryProcessor), this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteWithPredicateCodec.ResponseParameters resultParameters = MapExecuteWithPredicateCodec.decodeResponse(response);
        return this.prepareResult(resultParameters.response);
    }

    @Override
    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator) {
        Preconditions.checkNotNull(aggregator, NULL_AGGREGATOR_IS_NOT_ALLOWED);
        ClientMessage request = MapAggregateCodec.encodeRequest(this.name, this.toData(aggregator));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAggregateCodec.ResponseParameters resultParameters = MapAggregateCodec.decodeResponse(response);
        return (R)this.toObject(resultParameters.response);
    }

    @Override
    public <R> R aggregate(Aggregator<Map.Entry<K, V>, R> aggregator, Predicate<K, V> predicate) {
        Preconditions.checkNotNull(aggregator, NULL_AGGREGATOR_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(predicate, NULL_PREDICATE_IS_NOT_ALLOWED);
        ClientMessage request = MapAggregateWithPredicateCodec.encodeRequest(this.name, this.toData(aggregator), this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapAggregateWithPredicateCodec.ResponseParameters resultParameters = MapAggregateWithPredicateCodec.decodeResponse(response);
        return (R)this.toObject(resultParameters.response);
    }

    @Override
    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection) {
        ClientMessage request = MapProjectCodec.encodeRequest(this.name, this.toData(projection));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapProjectCodec.ResponseParameters resultParameters = MapProjectCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    public <R> Collection<R> project(Projection<Map.Entry<K, V>, R> projection, Predicate<K, V> predicate) {
        ClientMessage request = MapProjectWithPredicateCodec.encodeRequest(this.name, this.toData(projection), this.toData(predicate));
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapProjectWithPredicateCodec.ResponseParameters resultParameters = MapProjectWithPredicateCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-map-" + this.name);
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    @Override
    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            Preconditions.isNotNull(jobTracker, "jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMap(this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator<Map.Entry, Result> collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture<Result> future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException(e);
        }
    }

    @Override
    public QueryCache<K, V> getQueryCache(String name) {
        Preconditions.checkNotNull(name, "name cannot be null");
        return this.getQueryCacheInternal(name, null, null, null, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(String name, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        return this.getQueryCacheInternal(name, null, predicate, includeValue, this);
    }

    @Override
    public QueryCache<K, V> getQueryCache(String name, MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotInstanceOf(PagingPredicate.class, predicate, "predicate");
        return this.getQueryCacheInternal(name, listener, predicate, includeValue, this);
    }

    private QueryCache getQueryCacheInternal(String name, MapListener listener, Predicate predicate, Boolean includeValue, IMap map) {
        QueryCacheRequest request = QueryCacheRequests.newQueryCacheRequest().withCacheName(name).withCacheId(UuidUtil.newUnsecureUuidString()).withListener(listener).withPredicate(predicate).withIncludeValue(includeValue).forMap(map).withContext(this.queryCacheContext);
        return this.createQueryCache(request);
    }

    private QueryCache<K, V> createQueryCache(QueryCacheRequest request) {
        SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
        QueryCacheEndToEndProvider queryCacheEndToEndProvider = subscriberContext.getEndToEndQueryCacheProvider();
        return queryCacheEndToEndProvider.getOrCreateQueryCache(request.getMapName(), request.getCacheName(), new ClientQueryCacheEndToEndConstructor(request));
    }

    @Override
    public Map<K, Object> executeOnKeys(Set<K> keys, EntryProcessor entryProcessor) {
        Preconditions.checkNotNull(keys, NULL_KEY_IS_NOT_ALLOWED);
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        Collection<Data> dataCollection = CollectionUtil.objectToDataCollection(keys, this.getSerializationService());
        ClientMessage request = MapExecuteOnKeysCodec.encodeRequest(this.name, this.toData(entryProcessor), dataCollection);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapExecuteOnKeysCodec.ResponseParameters resultParameters = MapExecuteOnKeysCodec.decodeResponse(response);
        return this.prepareResult(resultParameters.response);
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public int size() {
        ClientMessage request = MapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapSizeCodec.ResponseParameters resultParameters = MapSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = MapIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MapIsEmptyCodec.ResponseParameters resultParameters = MapIsEmptyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        ClientPartitionService partitionService = this.getContext().getPartitionService();
        HashMap<Integer, List<Map.Entry<Data, Data>>> entryMap = new HashMap<Integer, List<Map.Entry<Data, Data>>>(partitionService.getPartitionCount());
        for (Map.Entry<K, V> entry : m.entrySet()) {
            Preconditions.checkNotNull(entry.getKey(), NULL_KEY_IS_NOT_ALLOWED);
            Preconditions.checkNotNull(entry.getValue(), NULL_VALUE_IS_NOT_ALLOWED);
            Data keyData = this.toData(entry.getKey());
            int partitionId = partitionService.getPartitionId(keyData);
            ArrayList<AbstractMap.SimpleEntry<Data, Data>> partition = (ArrayList<AbstractMap.SimpleEntry<Data, Data>>)entryMap.get(partitionId);
            if (partition == null) {
                partition = new ArrayList<AbstractMap.SimpleEntry<Data, Data>>();
                entryMap.put(partitionId, partition);
            }
            partition.add(new AbstractMap.SimpleEntry<Data, Data>(keyData, this.toData(entry.getValue())));
        }
        this.putAllInternal(entryMap);
    }

    protected void putAllInternal(Map<Integer, List<Map.Entry<Data, Data>>> entryMap) throws RuntimeException {
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>(entryMap.size());
        for (Map.Entry<Integer, List<Map.Entry<Data, Data>>> entry : entryMap.entrySet()) {
            Integer partitionId = entry.getKey();
            ClientMessage request = MapPutAllCodec.encodeRequest(this.name, (Collection<Map.Entry<Data, Data>>)entry.getValue());
            futures.add(new ClientInvocation(this.getClient(), request, partitionId).invoke());
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public void clear() {
        ClientMessage request = MapClearCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    public Iterator<Map.Entry<K, V>> iterator(int fetchSize, int partitionId, boolean prefetchValues) {
        return new ClientMapPartitionIterator(this, this.getContext(), fetchSize, partitionId, prefetchValues);
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<ClientMessage> createHandler(ListenerAdapter listenerAdapter) {
        return new ClientMapEventHandler(listenerAdapter);
    }

    public String toString() {
        return "IMap{name='" + this.name + '\'' + '}';
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    @Override
    protected void onDestroy() {
        try {
            SubscriberContext subscriberContext = this.queryCacheContext.getSubscriberContext();
            QueryCacheEndToEndProvider provider = subscriberContext.getEndToEndQueryCacheProvider();
            provider.destroyAllQueryCaches(this.name);
        }
        finally {
            super.onDestroy();
        }
    }

    private class ClientMapPartitionLostEventHandler
    extends MapAddPartitionLostListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private MapPartitionLostListener listener;

        public ClientMapPartitionLostEventHandler(MapPartitionLostListener listener) {
            this.listener = listener;
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }

        @Override
        public void handle(int partitionId, String uuid) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            this.listener.partitionLost(new MapPartitionLostEvent(ClientMapProxy.this.name, member, -1, partitionId));
        }
    }

    private class ClientMapEventHandler
    extends MapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;

        ClientMapEventHandler(ListenerAdapter listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        @Override
        public void handle(Data key, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            Member member = ClientMapProxy.this.getContext().getClusterService().getMember(uuid);
            IMapEvent iMapEvent = this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            AbstractIMapEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case EXPIRED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(eventType, numberOfAffectedEntries, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)entryEventType));
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent(ClientMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMapProxy.this.getContext().getSerializationService());
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

