/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.core.IMap;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.subscriber.DefaultQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheFactory {
    private final ConcurrentMap<String, InternalQueryCache> internalQueryCaches = new ConcurrentHashMap<String, InternalQueryCache>();

    public InternalQueryCache create(QueryCacheRequest request) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.internalQueryCaches, request.getCacheName(), new InternalQueryCacheConstructor(request));
    }

    public boolean remove(InternalQueryCache queryCache) {
        return this.internalQueryCaches.remove(queryCache.getCacheName(), queryCache);
    }

    public InternalQueryCache getOrNull(String cacheName) {
        return (InternalQueryCache)this.internalQueryCaches.get(cacheName);
    }

    public int getQueryCacheCount() {
        return this.internalQueryCaches.size();
    }

    private static class InternalQueryCacheConstructor
    implements ConstructorFunction<String, InternalQueryCache> {
        private final QueryCacheRequest request;

        InternalQueryCacheConstructor(QueryCacheRequest request) {
            this.request = request;
        }

        @Override
        public InternalQueryCache createNew(String ignored) {
            String cacheName = this.request.getCacheName();
            String userGivenCacheName = this.request.getUserGivenCacheName();
            IMap delegate = this.request.getMap();
            QueryCacheContext context = this.request.getContext();
            return new DefaultQueryCache(cacheName, userGivenCacheName, delegate, context);
        }
    }
}

