/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.Offloadable;
import com.hazelcast.core.ReadOnly;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.EntryOffloadableLockMismatchException;
import com.hazelcast.map.impl.operation.EntryOffloadableSetUnlockOperation;
import com.hazelcast.map.impl.operation.MutatingKeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.BlockingOperation;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.operationservice.impl.responses.CallTimeoutResponse;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class EntryOperation
extends MutatingKeyBasedMapOperation
implements BackupAwareOperation,
BlockingOperation {
    private static final int SET_UNLOCK_FAST_RETRY_LIMIT = 10;
    private EntryProcessor entryProcessor;
    private transient boolean offloading;
    private transient Object oldValue;
    private transient EntryEventType eventType;
    private transient Object response;
    private transient Object dataValue;
    private transient boolean readOnly;
    private transient long begin;
    private transient OperationServiceImpl ops;
    private transient ExecutionService exs;
    private transient int setUnlockRetryCount;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        this.ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        this.exs = this.getNodeEngine().getExecutionService();
        this.begin = this.getNow();
        this.readOnly = this.entryProcessor instanceof ReadOnly;
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        if (this.offloading) {
            this.runOffloaded();
        } else {
            this.runVanilla();
        }
    }

    public void runOffloaded() {
        if (!(this.entryProcessor instanceof Offloadable)) {
            throw new HazelcastException("EntryProcessor is expected to implement Offloadable for this operation");
        }
        if (this.readOnly && this.entryProcessor.getBackupProcessor() != null) {
            throw new HazelcastException("EntryProcessor.getBackupProcessor() should return null if ReadOnly implemented");
        }
        boolean shouldCloneForOffloading = InMemoryFormat.OBJECT.equals((Object)this.mapContainer.getMapConfig().getInMemoryFormat());
        Object value = this.recordStore.get(this.dataKey, false);
        value = shouldCloneForOffloading ? this.toData(value) : value;
        String executorName = ((Offloadable)((Object)this.entryProcessor)).getExecutorName();
        String string = executorName = executorName.equals("hz:offloadable") ? "hz:offloadable" : executorName;
        if (this.readOnly) {
            this.runOffloadedReadOnlyEntryProcessor(value, executorName);
        } else {
            this.runOffloadedModifyingEntryProcessor(value, executorName);
        }
    }

    private void runOffloadedReadOnlyEntryProcessor(final Object previousValue, String executorName) {
        this.ops.onStartAsyncOperation(this);
        this.getNodeEngine().getExecutionService().execute(executorName, new Runnable(){

            @Override
            public void run() {
                try {
                    Map.Entry entry = EntryOperation.this.createMapEntry(EntryOperation.this.dataKey, previousValue);
                    Data result = EntryOperation.this.process(entry);
                    if (!EntryOperation.this.noOp(entry, previousValue)) {
                        EntryOperation.this.throwModificationInReadOnlyException();
                    }
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, result);
                }
                catch (Throwable t) {
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, t);
                }
                finally {
                    EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                }
            }
        });
    }

    private void throwModificationInReadOnlyException() {
        throw new UnsupportedOperationException("Entry Processor " + this.entryProcessor.getClass().getName() + " marked as ReadOnly tried to modify map " + this.name + ". This is not supported. Remove " + "the ReadOnly marker from the Entry Processor or do not modify the entry in the process " + "method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runOffloadedModifyingEntryProcessor(final Object previousValue, String executorName) {
        OperationServiceImpl ops = (OperationServiceImpl)this.getNodeEngine().getOperationService();
        final String finalCaller = UuidUtil.newUnsecureUuidString();
        Data finalDataKey = this.dataKey;
        final long finalThreadId = this.threadId;
        long finalCallId = this.getCallId();
        final long finalBegin = this.begin;
        this.lock(finalDataKey, finalCaller, finalThreadId, finalCallId);
        try {
            ops.onStartAsyncOperation(this);
            this.getNodeEngine().getExecutionService().execute(executorName, new Runnable(){

                @Override
                public void run() {
                    try {
                        Map.Entry entry = EntryOperation.this.createMapEntry(EntryOperation.this.dataKey, previousValue);
                        Data result = EntryOperation.this.process(entry);
                        if (!EntryOperation.this.noOp(entry, previousValue)) {
                            Data newValue = EntryOperation.this.toData(entry.getValue());
                            EntryEventType modificationType = entry.getValue() == null ? EntryEventType.REMOVED : (previousValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED);
                            EntryOperation.this.updateAndUnlock(EntryOperation.this.toData(previousValue), newValue, modificationType, finalCaller, finalThreadId, result, finalBegin);
                        } else {
                            EntryOperation.this.unlockOnly(result, finalCaller, finalThreadId, finalBegin);
                        }
                    }
                    catch (Throwable t) {
                        EntryOperation.this.getLogger().severe("Unexpected error on Offloadable execution", t);
                        EntryOperation.this.unlockOnly(t, finalCaller, finalThreadId, finalBegin);
                    }
                }
            });
        }
        catch (Throwable t) {
            try {
                this.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId, t);
                ExceptionUtil.sneakyThrow(t);
            }
            finally {
                ops.onCompletionAsyncOperation(this);
            }
        }
    }

    private void lock(Data finalDataKey, String finalCaller, long finalThreadId, long finalCallId) {
        boolean locked = this.recordStore.localLock(finalDataKey, finalCaller, finalThreadId, finalCallId, -1L);
        if (!locked) {
            throw new IllegalStateException(String.format("Could not obtain a lock by the caller=%s and threadId=%d", finalCaller, this.threadId));
        }
    }

    private void unlock(Data finalDataKey, String finalCaller, long finalThreadId, long finalCallId, Throwable cause) {
        boolean unlocked = this.recordStore.unlock(finalDataKey, finalCaller, finalThreadId, finalCallId);
        if (!unlocked) {
            throw new IllegalStateException(String.format("Could not unlock by the caller=%s and threadId=%d", finalCaller, this.threadId), cause);
        }
    }

    private void updateAndUnlock(Data previousValue, Data newValue, EntryEventType modificationType, String caller, long threadId, final Object result, long now) {
        EntryOffloadableSetUnlockOperation updateOperation = new EntryOffloadableSetUnlockOperation(this.name, modificationType, this.dataKey, previousValue, newValue, caller, threadId, now, this.entryProcessor.getBackupProcessor());
        updateOperation.setPartitionId(this.getPartitionId());
        updateOperation.setReplicaIndex(0);
        updateOperation.setNodeEngine(this.getNodeEngine());
        updateOperation.setCallerUuid(this.getCallerUuid());
        OperationAccessor.setCallerAddress(updateOperation, this.getCallerAddress());
        OperationResponseHandler setUnlockResponseHandler = new OperationResponseHandler(){

            public void sendResponse(Operation op, Object response) {
                if (EntryOperation.this.isRetryable(response) || EntryOperation.this.isTimeout(response)) {
                    this.retry(op);
                } else {
                    this.handleResponse(response);
                }
            }

            private void retry(final Operation op) {
                EntryOperation.this.setUnlockRetryCount++;
                if (EntryOperation.this.isFastRetryLimitReached()) {
                    EntryOperation.this.exs.schedule(new Runnable(){

                        @Override
                        public void run() {
                            EntryOperation.this.ops.execute(op);
                        }
                    }, 500L, TimeUnit.MILLISECONDS);
                } else {
                    EntryOperation.this.ops.execute(op);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void handleResponse(Object response) {
                if (response instanceof Throwable) {
                    Throwable t = (Throwable)response;
                    try {
                        if (t instanceof EntryOffloadableLockMismatchException) {
                            t = new RetryableHazelcastException(t.getMessage(), t);
                        }
                        EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, t);
                    }
                    finally {
                        EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                    }
                }
                try {
                    EntryOperation.this.getOperationResponseHandler().sendResponse(EntryOperation.this, result);
                }
                finally {
                    EntryOperation.this.ops.onCompletionAsyncOperation(EntryOperation.this);
                }
            }
        };
        updateOperation.setOperationResponseHandler(setUnlockResponseHandler);
        this.ops.execute(updateOperation);
    }

    private boolean isRetryable(Object response) {
        return response instanceof RetryableHazelcastException && !(response instanceof WrongTargetException);
    }

    private boolean isTimeout(Object response) {
        return response instanceof CallTimeoutResponse;
    }

    private boolean isFastRetryLimitReached() {
        return this.setUnlockRetryCount > 10;
    }

    private void unlockOnly(Object result, String caller, long threadId, long now) {
        this.updateAndUnlock(null, null, null, caller, threadId, result, now);
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.offloading) {
            this.sendResponse(e);
        } else {
            super.onExecutionFailure(e);
        }
    }

    @Override
    public boolean returnsResponse() {
        if (this.offloading) {
            return false;
        }
        return super.returnsResponse();
    }

    private void runVanilla() {
        long now = this.getNow();
        boolean shouldClone = this.mapContainer.shouldCloneOnEntryProcessing();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        this.oldValue = this.recordStore.get(this.dataKey, false);
        Object value = shouldClone ? serializationService.toObject(serializationService.toData(this.oldValue)) : this.oldValue;
        Map.Entry entry = this.createMapEntry(this.dataKey, value);
        this.response = this.process(entry);
        if (this.noOp(entry, this.oldValue)) {
            return;
        }
        if (this.entryProcessor instanceof ReadOnly) {
            this.throwModificationInReadOnlyException();
        }
        if (this.entryRemoved(entry, now)) {
            return;
        }
        this.entryAddedOrUpdated(entry, now);
    }

    @Override
    public void afterRun() throws Exception {
        if (!this.offloading) {
            super.afterRun();
            if (this.eventType == null) {
                return;
            }
            this.mapServiceContext.interceptAfterPut(this.name, this.dataValue);
            if (this.isPostProcessing(this.recordStore)) {
                Object record = this.recordStore.getRecord(this.dataKey);
                this.dataValue = record == null ? null : record.getValue();
            }
            this.invalidateNearCache(this.dataKey);
            this.publishEntryEvent();
            this.publishWanReplicationEvent();
            this.evict(this.dataKey);
        }
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return new LockWaitNotifyKey(new DefaultObjectNamespace("hz:impl:mapService", this.name), this.dataKey);
    }

    @Override
    public boolean shouldWait() {
        if (this.entryProcessor instanceof ReadOnly) {
            this.offloading = this.isOffloadingRequested(this.entryProcessor);
            return false;
        }
        if (!this.recordStore.isLocked(this.dataKey) && this.isOffloadingRequested(this.entryProcessor)) {
            this.offloading = true;
            return false;
        }
        this.offloading = false;
        return !this.recordStore.canAcquireLock(this.dataKey, this.getCallerUuid(), this.getThreadId());
    }

    private boolean isOffloadingRequested(EntryProcessor entryProcessor) {
        String executorName;
        return entryProcessor instanceof Offloadable && !(executorName = ((Offloadable)((Object)entryProcessor)).getExecutorName()).equals("no-offloading");
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        if (this.offloading) {
            return null;
        }
        return this.response;
    }

    @Override
    public Operation getBackupOperation() {
        if (this.offloading) {
            return null;
        }
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        if (this.offloading) {
            return false;
        }
        return this.mapContainer.getTotalBackupCount() > 0 && this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    private Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    private boolean entryRemoved(Map.Entry entry, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.delete(this.dataKey);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.eventType = EntryEventType.REMOVED;
            return true;
        }
        return false;
    }

    private void entryAddedOrUpdated(Map.Entry entry, long now) {
        this.dataValue = entry.getValue();
        this.recordStore.set(this.dataKey, this.dataValue, -1L);
        this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
        this.eventType = this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
    }

    private Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    private boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    private void nullifyOldValueIfNecessary() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
            this.oldValue = null;
        }
    }

    private void publishEntryEvent() {
        if (this.hasRegisteredListenerForThisMap()) {
            this.nullifyOldValueIfNecessary();
            this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.oldValue, this.dataValue);
        }
    }

    private void publishWanReplicationEvent() {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        Data key = this.dataKey;
        if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
            this.mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                this.dataValue = this.toData(this.dataValue);
                EntryView<Data, Object> entryView = EntryViews.createSimpleEntryView(key, this.dataValue, record);
                this.mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public int getId() {
        return 20;
    }
}

