/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.core.RingbufferStore;
import com.hazelcast.core.RingbufferStoreFactory;
import com.hazelcast.util.Preconditions;
import java.util.Map;
import java.util.Properties;

public class RingbufferStoreConfig {
    private boolean enabled = true;
    private String className;
    private String factoryClassName;
    private Properties properties = new Properties();
    private RingbufferStore storeImplementation;
    private RingbufferStoreFactory factoryImplementation;
    private RingbufferStoreConfigReadOnly readOnly;

    public RingbufferStoreConfig() {
    }

    public RingbufferStoreConfig(RingbufferStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.storeImplementation = config.getStoreImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    public RingbufferStore getStoreImplementation() {
        return this.storeImplementation;
    }

    public RingbufferStoreConfig setStoreImplementation(RingbufferStore storeImplementation) {
        this.storeImplementation = storeImplementation;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RingbufferStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public RingbufferStoreConfig setClassName(String className) {
        this.className = className;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public RingbufferStoreConfig setProperties(Properties properties) {
        this.properties = Preconditions.isNotNull(properties, "properties");
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public RingbufferStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public RingbufferStoreConfig setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
        return this;
    }

    public RingbufferStoreFactory getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public RingbufferStoreConfig setFactoryImplementation(RingbufferStoreFactory factoryImplementation) {
        this.factoryImplementation = factoryImplementation;
        return this;
    }

    public String toString() {
        return "RingbufferStoreConfig{enabled=" + this.enabled + ", className='" + this.className + '\'' + ", properties=" + this.properties + '}';
    }

    public RingbufferStoreConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new RingbufferStoreConfigReadOnly(this);
        }
        return this.readOnly;
    }

    private static class RingbufferStoreConfigReadOnly
    extends RingbufferStoreConfig {
        RingbufferStoreConfigReadOnly(RingbufferStoreConfig config) {
            super(config);
        }

        @Override
        public RingbufferStoreConfig setStoreImplementation(RingbufferStore storeImplementation) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setEnabled(boolean enabled) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setClassName(String className) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setProperties(Properties properties) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setProperty(String name, String value) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setFactoryClassName(String factoryClassName) {
            throw new UnsupportedOperationException("This config is read-only.");
        }

        @Override
        public RingbufferStoreConfig setFactoryImplementation(RingbufferStoreFactory factoryImplementation) {
            throw new UnsupportedOperationException("This config is read-only.");
        }
    }
}

