/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.version;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.StringUtil;
import java.io.IOException;

public final class ClusterVersion
implements IdentifiedDataSerializable,
Comparable<ClusterVersion> {
    public static final ClusterVersion UNKNOWN = new ClusterVersion(0, 0);
    private byte major;
    private byte minor;

    public ClusterVersion() {
    }

    public ClusterVersion(int major, int minor) {
        this.major = (byte)major;
        this.minor = (byte)minor;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVersion that = (ClusterVersion)o;
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.major);
        out.writeByte(this.minor);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.major = in.readByte();
        this.minor = in.readByte();
    }

    @Override
    public int compareTo(ClusterVersion o) {
        int thisVersion = this.major << 8 & 0xFF00 | this.minor & 0xFF;
        int thatVersion = o.major << 8 & 0xFF00 | o.minor & 0xFF;
        if (thisVersion > thatVersion) {
            return 1;
        }
        return thisVersion == thatVersion ? 0 : -1;
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 35;
    }

    public static ClusterVersion of(int major, int minor) {
        return new ClusterVersion(major, minor);
    }

    public static ClusterVersion of(String version) {
        String[] tokens = StringUtil.tokenizeVersionString(version);
        if (tokens != null && tokens.length >= 2) {
            return new ClusterVersion(Byte.valueOf(tokens[0]).byteValue(), Byte.valueOf(tokens[1]).byteValue());
        }
        throw new IllegalArgumentException("Cannot parse " + version + " to ClusterVersion.");
    }
}

