/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl.operations;

import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.AbstractSchedulerOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetAllScheduledOperation
extends AbstractSchedulerOperation {
    private static final int MEMBER_BIN = -1;
    private List<ScheduledTaskHandler> response;

    public GetAllScheduledOperation() {
    }

    public GetAllScheduledOperation(String schedulerName) {
        super(schedulerName);
    }

    @Override
    public void run() throws Exception {
        ArrayList<ScheduledTaskHandler> handlers = new ArrayList<ScheduledTaskHandler>();
        DistributedScheduledExecutorService service = (DistributedScheduledExecutorService)this.getService();
        int partitionCount = this.getNodeEngine().getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.populateScheduledForHolder(handlers, service, i);
        }
        this.populateScheduledForHolder(handlers, service, -1);
        this.response = handlers;
    }

    private void populateScheduledForHolder(List<ScheduledTaskHandler> handlers, DistributedScheduledExecutorService service, int holderId) {
        ScheduledExecutorContainerHolder partition = service.getPartitionOrMemberBin(holderId);
        Collection<ScheduledExecutorContainer> containers = partition.getContainers();
        for (ScheduledExecutorContainer container : containers) {
            Collection<ScheduledTaskDescriptor> tasks = container.getTasks();
            for (ScheduledTaskDescriptor task : tasks) {
                if (!task.isTaskOwner()) continue;
                handlers.add(container.offprintHandler(task.getDefinition().getName()));
            }
        }
    }

    @Override
    public List<ScheduledTaskHandler> getResponse() {
        return this.response;
    }

    @Override
    public int getId() {
        return 22;
    }
}

