/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.projection.impl;

import com.hazelcast.projection.Projection;
import com.hazelcast.query.impl.Extractable;

public class MultiAttributeProjection<I>
extends Projection<I, Object[]> {
    private final String[] attributePaths;
    private final int attributeCount;

    public MultiAttributeProjection(String ... attributePath) {
        if (attributePath.length == 0) {
            throw new IllegalArgumentException("You need to specify at least one attributePath");
        }
        this.attributePaths = attributePath;
        this.attributeCount = attributePath.length;
    }

    @Override
    public Object[] transform(I input) {
        if (input instanceof Extractable) {
            Extractable extractable = (Extractable)input;
            Object[] result = new Object[this.attributeCount];
            for (int i = 0; i < this.attributeCount; ++i) {
                result[i] = extractable.getAttributeValue(this.attributePaths[i]);
            }
            return result;
        }
        throw new IllegalArgumentException("The given map entry is not extractable");
    }
}

