/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.operation.MapReplicationOperation;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.publisher.AccumulatorSweeper;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.util.Iterator;

class MapMigrationAwareService
implements MigrationAwareService {
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;

    MapMigrationAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.serializationService = mapServiceContext.getNodeEngine().getSerializationService();
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent event) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(partitionId);
        MapReplicationOperation operation = new MapReplicationOperation(container, partitionId, event.getReplicaIndex());
        operation.setService(this.mapServiceContext.getService());
        return operation;
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        this.migrateIndex(event);
        if (MigrationEndpoint.SOURCE == event.getMigrationEndpoint()) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
            this.getMetaDataGenerator().resetMetadata(event.getPartitionId());
        } else if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint()) {
            this.getMetaDataGenerator().getOrCreateUuid(event.getPartitionId());
        }
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : partitionContainer.getAllRecordStores()) {
            recordStore.startLoading();
        }
        this.mapServiceContext.reloadOwnedPartitions();
        QueryCacheContext queryCacheContext = this.mapServiceContext.getQueryCacheContext();
        PublisherContext publisherContext = queryCacheContext.getPublisherContext();
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            int partitionId = event.getPartitionId();
            AccumulatorSweeper.flushAccumulator(publisherContext, partitionId);
            AccumulatorSweeper.removeAccumulator(publisherContext, partitionId);
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (MigrationEndpoint.DESTINATION == event.getMigrationEndpoint()) {
            this.clearMapsHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
            this.getMetaDataGenerator().resetMetadata(event.getPartitionId());
        } else if (MigrationEndpoint.SOURCE == event.getMigrationEndpoint()) {
            this.getMetaDataGenerator().getOrCreateUuid(event.getPartitionId());
        }
        this.mapServiceContext.reloadOwnedPartitions();
    }

    private void clearMapsHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            this.mapServiceContext.clearPartitionData(partitionId);
        } else {
            this.mapServiceContext.clearMapsHavingLesserBackupCountThan(partitionId, thresholdReplicaIndex);
        }
    }

    private MetaDataGenerator getMetaDataGenerator() {
        return this.mapServiceContext.getMapNearCacheManager().getInvalidator().getMetaDataGenerator();
    }

    private void migrateIndex(PartitionMigrationEvent event) {
        long now = this.getNow();
        PartitionContainer container = this.mapServiceContext.getPartitionContainer(event.getPartitionId());
        for (RecordStore recordStore : container.getMaps().values()) {
            MapContainer mapContainer = this.mapServiceContext.getMapContainer(recordStore.getName());
            Indexes indexes = mapContainer.getIndexes();
            if (!indexes.hasIndex()) continue;
            Iterator<Record> iterator = recordStore.iterator(now, false);
            while (iterator.hasNext()) {
                Object value;
                Record record = iterator.next();
                Data key = record.getKey();
                if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
                    assert (event.getNewReplicaIndex() != 0) : "Invalid migration event: " + event;
                    value = Records.getValueOrCachedValue(record, this.serializationService);
                    indexes.removeEntryIndex(key, value);
                    continue;
                }
                if (event.getNewReplicaIndex() != 0 || (value = Records.getValueOrCachedValue(record, this.serializationService)) == null) continue;
                QueryableEntry queryEntry = mapContainer.newQueryEntry(record.getKey(), value);
                indexes.saveEntryIndex(queryEntry, null);
            }
        }
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }
}

