/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.IFunction;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.eviction.MapEvictionPolicy;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreContextFactory;
import com.hazelcast.map.impl.query.QueryEntryFactory;
import com.hazelcast.map.impl.record.DataRecordFactory;
import com.hazelcast.map.impl.record.ObjectRecordFactory;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.Indexes;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MemoryInfoAccessor;
import com.hazelcast.util.RuntimeMemoryInfoAccessor;
import com.hazelcast.wan.WanReplicationPublisher;
import com.hazelcast.wan.WanReplicationService;
import java.util.concurrent.atomic.AtomicInteger;

public class MapContainer {
    protected final String name;
    protected final String quorumName;
    protected final MapServiceContext mapServiceContext;
    protected final Indexes indexes;
    protected final Extractors extractors;
    protected final PartitioningStrategy partitioningStrategy;
    protected final MapStoreContext mapStoreContext;
    protected final SerializationService serializationService;
    protected final QueryEntryFactory queryEntryFactory;
    protected final InterceptorRegistry interceptorRegistry = new InterceptorRegistry();
    protected final IFunction<Object, Data> toDataFunction = new IFunction<Object, Data>(){

        @Override
        public Data apply(Object input) {
            SerializationService ss = MapContainer.this.mapStoreContext.getSerializationService();
            return ss.toData(input, MapContainer.this.partitioningStrategy);
        }
    };
    protected final ConstructorFunction<Void, RecordFactory> recordFactoryConstructor;
    protected final AtomicInteger invalidationListenerCount = new AtomicInteger();
    protected WanReplicationPublisher wanReplicationPublisher;
    protected MapMergePolicy wanMergePolicy;
    protected volatile Evictor evictor;
    protected volatile MapConfig mapConfig;

    public MapContainer(String name, Config config, MapServiceContext mapServiceContext) {
        this.name = name;
        this.mapConfig = config.findMapConfig(name);
        this.mapServiceContext = mapServiceContext;
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        this.partitioningStrategy = this.createPartitioningStrategy();
        this.quorumName = this.mapConfig.getQuorumName();
        this.serializationService = nodeEngine.getSerializationService();
        this.recordFactoryConstructor = this.createRecordFactoryConstructor(this.serializationService);
        this.queryEntryFactory = new QueryEntryFactory(this.mapConfig.getCacheDeserializedValues());
        this.initWanReplication(nodeEngine);
        this.extractors = new Extractors(this.mapConfig.getMapAttributeConfigs(), config.getClassLoader());
        this.indexes = new Indexes((InternalSerializationService)this.serializationService, this.extractors);
        this.mapStoreContext = MapStoreContextFactory.createMapStoreContext(this);
        this.mapStoreContext.start();
        this.initEvictor();
    }

    public void initEvictor() {
        MapEvictionPolicy mapEvictionPolicy = this.mapConfig.getMapEvictionPolicy();
        if (mapEvictionPolicy == null) {
            this.evictor = Evictor.NULL_EVICTOR;
        } else {
            MemoryInfoAccessor memoryInfoAccessor = MapContainer.getMemoryInfoAccessor();
            EvictionChecker evictionChecker = new EvictionChecker(memoryInfoAccessor, this.mapServiceContext);
            IPartitionService partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
            this.evictor = new EvictorImpl(mapEvictionPolicy, evictionChecker, partitionService);
        }
    }

    protected static MemoryInfoAccessor getMemoryInfoAccessor() {
        MemoryInfoAccessor pluggedMemoryInfoAccessor = MapContainer.getPluggedMemoryInfoAccessor();
        return pluggedMemoryInfoAccessor != null ? pluggedMemoryInfoAccessor : new RuntimeMemoryInfoAccessor();
    }

    private static MemoryInfoAccessor getPluggedMemoryInfoAccessor() {
        String memoryInfoAccessorImpl = System.getProperty("hazelcast.memory.info.accessor.impl");
        if (memoryInfoAccessorImpl == null) {
            return null;
        }
        try {
            return (MemoryInfoAccessor)ClassLoaderUtil.newInstance(null, memoryInfoAccessorImpl);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    ConstructorFunction<Void, RecordFactory> createRecordFactoryConstructor(final SerializationService serializationService) {
        return new ConstructorFunction<Void, RecordFactory>(){

            @Override
            public RecordFactory createNew(Void notUsedArg) {
                switch (MapContainer.this.mapConfig.getInMemoryFormat()) {
                    case BINARY: {
                        return new DataRecordFactory(MapContainer.this.mapConfig, serializationService, MapContainer.this.partitioningStrategy);
                    }
                    case OBJECT: {
                        return new ObjectRecordFactory(MapContainer.this.mapConfig, serializationService);
                    }
                }
                throw new IllegalArgumentException("Invalid storage format: " + (Object)((Object)MapContainer.this.mapConfig.getInMemoryFormat()));
            }
        };
    }

    public void initWanReplication(NodeEngine nodeEngine) {
        WanReplicationRef wanReplicationRef = this.mapConfig.getWanReplicationRef();
        if (wanReplicationRef == null) {
            return;
        }
        String wanReplicationRefName = wanReplicationRef.getName();
        WanReplicationService wanReplicationService = nodeEngine.getWanReplicationService();
        this.wanReplicationPublisher = wanReplicationService.getWanReplicationPublisher(wanReplicationRefName);
        this.wanMergePolicy = this.mapServiceContext.getMergePolicyProvider().getMergePolicy(wanReplicationRef.getMergePolicy());
    }

    private PartitioningStrategy createPartitioningStrategy() {
        return this.mapServiceContext.getPartitioningStrategy(this.mapConfig.getName(), this.mapConfig.getPartitioningStrategyConfig());
    }

    public Indexes getIndexes() {
        return this.indexes;
    }

    public WanReplicationPublisher getWanReplicationPublisher() {
        return this.wanReplicationPublisher;
    }

    public MapMergePolicy getWanMergePolicy() {
        return this.wanMergePolicy;
    }

    public boolean isWanReplicationEnabled() {
        return this.wanReplicationPublisher != null && this.wanMergePolicy != null;
    }

    public void checkWanReplicationQueues() {
        if (this.isWanReplicationEnabled()) {
            this.wanReplicationPublisher.checkWanReplicationQueues();
        }
    }

    public int getTotalBackupCount() {
        return this.getBackupCount() + this.getAsyncBackupCount();
    }

    public int getBackupCount() {
        return this.mapConfig.getBackupCount();
    }

    public int getAsyncBackupCount() {
        return this.mapConfig.getAsyncBackupCount();
    }

    public PartitioningStrategy getPartitioningStrategy() {
        return this.partitioningStrategy;
    }

    public MapServiceContext getMapServiceContext() {
        return this.mapServiceContext;
    }

    public MapStoreContext getMapStoreContext() {
        return this.mapStoreContext;
    }

    public MapConfig getMapConfig() {
        return this.mapConfig;
    }

    public void setMapConfig(MapConfig mapConfig) {
        this.mapConfig = mapConfig;
    }

    public String getName() {
        return this.name;
    }

    public String getQuorumName() {
        return this.quorumName;
    }

    public IFunction<Object, Data> toData() {
        return this.toDataFunction;
    }

    public ConstructorFunction<Void, RecordFactory> getRecordFactoryConstructor() {
        return this.recordFactoryConstructor;
    }

    public QueryableEntry newQueryEntry(Data key, Object value) {
        return this.queryEntryFactory.newEntry((InternalSerializationService)this.serializationService, key, value, this.extractors);
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    public void setEvictor(Evictor evictor) {
        this.evictor = evictor;
    }

    public Extractors getExtractors() {
        return this.extractors;
    }

    public boolean hasInvalidationListener() {
        return this.invalidationListenerCount.get() > 0;
    }

    public void increaseInvalidationListenerCount() {
        this.invalidationListenerCount.incrementAndGet();
    }

    public void decreaseInvalidationListenerCount() {
        this.invalidationListenerCount.decrementAndGet();
    }

    public InterceptorRegistry getInterceptorRegistry() {
        return this.interceptorRegistry;
    }

    public void onDestroy() {
    }
}

