/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import java.security.SecureRandom;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadLocalRandomProvider {
    private static final AtomicLong SEED_UNIQUIFIER = new AtomicLong(8682522807148012L);
    private static final long MOTHER_OF_MAGIC_NUMBERS = 181783497276652981L;
    private static final ThreadLocal<Random> THREAD_LOCAL_RANDOM = new ThreadLocal();
    private static final ThreadLocal<SecureRandom> THREAD_LOCAL_SECURE_RANDOM = new ThreadLocal();

    private ThreadLocalRandomProvider() {
    }

    public static Random get() {
        Random random = THREAD_LOCAL_RANDOM.get();
        if (random == null) {
            random = new Random(ThreadLocalRandomProvider.seedUniquifier() ^ System.nanoTime());
            THREAD_LOCAL_RANDOM.set(random);
        }
        return random;
    }

    public static SecureRandom getSecure() {
        SecureRandom random = THREAD_LOCAL_SECURE_RANDOM.get();
        if (random == null) {
            random = new SecureRandom();
            THREAD_LOCAL_SECURE_RANDOM.set(random);
        }
        return random;
    }

    private static long seedUniquifier() {
        long next;
        long current;
        while (!SEED_UNIQUIFIER.compareAndSet(current = SEED_UNIQUIFIER.get(), next = current * 181783497276652981L)) {
        }
        return next;
    }
}

