/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.InputStream;
import java.util.Properties;

public final class BuildInfoProvider {
    public static final BuildInfo BUILD_INFO;
    public static final String HAZELCAST_INTERNAL_OVERRIDE_VERSION = "hazelcast.internal.override.version";
    private static final ILogger LOGGER;

    private BuildInfoProvider() {
    }

    public static BuildInfo getBuildInfo() {
        Properties properties = BuildInfoProvider.loadPropertiesFromResource("hazelcast-runtime.properties");
        Properties enterpriseProperties = BuildInfoProvider.loadPropertiesFromResource("hazelcast-enterprise-runtime.properties");
        Properties jetProperties = BuildInfoProvider.loadPropertiesFromResource("jet-runtime.properties");
        BuildInfo buildInfo = BuildInfoProvider.readBuildInfoProperties(properties, null);
        if (!enterpriseProperties.isEmpty()) {
            buildInfo = BuildInfoProvider.readBuildInfoProperties(enterpriseProperties, buildInfo);
        }
        BuildInfoProvider.setJetProperties(jetProperties, buildInfo);
        return buildInfo;
    }

    private static void setJetProperties(Properties properties, BuildInfo buildInfo) {
        if (properties.isEmpty()) {
            return;
        }
        String version = properties.getProperty("jet.version");
        String build = properties.getProperty("jet.build");
        String revision = properties.getProperty("jet.git.revision");
        JetBuildInfo jetBuildInfo = new JetBuildInfo(version, build, revision);
        buildInfo.setJetBuildInfo(jetBuildInfo);
    }

    private static BuildInfo readBuildInfoProperties(Properties runtimeProperties, BuildInfo upstreamBuildInfo) {
        String version = runtimeProperties.getProperty("hazelcast.version");
        String distribution = runtimeProperties.getProperty("hazelcast.distribution");
        String revision = runtimeProperties.getProperty("hazelcast.git.revision", "");
        if (!revision.isEmpty() && revision.equals("${git.commit.id.abbrev}")) {
            revision = "";
        }
        boolean enterprise = !"Hazelcast".equals(distribution);
        Integer hazelcastBuild = Integer.getInteger("hazelcast.build", -1);
        String build = hazelcastBuild == -1 ? runtimeProperties.getProperty("hazelcast.build") : String.valueOf(hazelcastBuild);
        int buildNumber = Integer.parseInt(build);
        String overridingVersion = System.getProperty(HAZELCAST_INTERNAL_OVERRIDE_VERSION);
        if (overridingVersion != null) {
            LOGGER.info("Overriding hazelcast version with system property value " + overridingVersion);
            version = overridingVersion;
        }
        String sv = runtimeProperties.getProperty("hazelcast.serialization.version");
        byte serialVersion = Byte.parseByte(sv);
        return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion, upstreamBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromResource(String resourceName) {
        InputStream properties = BuildInfoProvider.class.getClassLoader().getResourceAsStream(resourceName);
        Properties runtimeProperties = new Properties();
        try {
            if (properties != null) {
                runtimeProperties.load(properties);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(properties);
        }
        return runtimeProperties;
    }

    static {
        LOGGER = Logger.getLogger(BuildInfoProvider.class);
        BUILD_INFO = BuildInfoProvider.getBuildInfo();
    }
}

