/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetAllScheduledFuturesCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorShutdownCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorSubmitToPartitionCodec;
import com.hazelcast.client.proxy.ClientScheduledFutureProxy;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.Member;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.nio.Address;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledRunnableAdapter;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ClientScheduledExecutorProxy
extends PartitionSpecificClientProxy
implements IScheduledExecutorService {
    private static final int GET_ALL_SCHEDULED_TIMEOUT = 10;
    private static final int SHUTDOWN_TIMEOUT = 10;
    private static final FutureUtil.ExceptionHandler WHILE_SHUTDOWN_EXCEPTION_HANDLER = FutureUtil.logAllExceptions("Exception while ScheduledExecutor Service shutdown", Level.FINEST);
    private static final ClientMessageDecoder SUBMIT_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder GET_ALL_SCHEDULED_DECODER = new ClientMessageDecoder(){

        public List<ScheduledTaskHandler> decodeClientMessage(ClientMessage clientMessage) {
            ArrayList<ScheduledTaskHandler> handlers = new ArrayList<ScheduledTaskHandler>();
            List<String> urns = ScheduledExecutorGetAllScheduledFuturesCodec.decodeResponse((ClientMessage)clientMessage).handlers;
            for (String urn : urns) {
                handlers.add(ScheduledTaskHandler.of(urn));
            }
            return handlers;
        }
    };

    public ClientScheduledExecutorProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public String toString() {
        return "ClientScheduledExecutorProxy{name='" + this.name + '\'' + '}';
    }

    @Override
    public IScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.schedule(adapter, delay, unit);
    }

    @Override
    public <V> IScheduledFuture<V> schedule(Callable<V> command, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    public IScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    public IScheduledFuture<?> scheduleOnMember(Runnable command, Member member, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    @Override
    public <V> IScheduledFuture<V> scheduleOnMember(Callable<V> command, Member member, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    @Override
    public IScheduledFuture<?> scheduleOnMemberAtFixedRate(Runnable command, Member member, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        return this.scheduleOnMembersAtFixedRate(command, Collections.singleton(member), initialDelay, period, unit).get(member);
    }

    @Override
    public IScheduledFuture<?> scheduleOnKeyOwner(Runnable command, Object key, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnKeyOwner(adapter, key, delay, unit);
    }

    @Override
    public <V> IScheduledFuture<V> scheduleOnKeyOwner(Callable<V> command, Object key, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    public IScheduledFuture<?> scheduleOnKeyOwnerAtFixedRate(Runnable command, Object key, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.scheduleOnPartition(name, definition, partitionId);
    }

    @Override
    public Map<Member, IScheduledFuture<?>> scheduleOnAllMembers(Runnable command, long delay, TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    @Override
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(Callable<V> command, long delay, TimeUnit unit) {
        return this.scheduleOnMembers(command, this.getContext().getClusterService().getMemberList(), delay, unit);
    }

    @Override
    public Map<Member, IScheduledFuture<?>> scheduleOnAllMembersAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.scheduleOnMembersAtFixedRate(command, this.getContext().getClusterService().getMemberList(), initialDelay, period, unit);
    }

    @Override
    public Map<Member, IScheduledFuture<?>> scheduleOnMembers(Runnable command, Collection<Member> members, long delay, TimeUnit unit) {
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnMembers(adapter, members, delay, unit);
    }

    @Override
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(Callable<V> command, Collection<Member> members, long delay, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        HashMap<Member, IScheduledFuture<IScheduledFuture<V>>> futures = new HashMap<Member, IScheduledFuture<IScheduledFuture<V>>>();
        for (Member member : members) {
            TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    @Override
    public Map<Member, IScheduledFuture<?>> scheduleOnMembersAtFixedRate(Runnable command, Collection<Member> members, long initialDelay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        String name = this.extractNameOrGenerateOne(command);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        HashMap futures = new HashMap();
        for (Member member : members) {
            TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
            futures.put(member, this.scheduleOnMember(name, member, definition));
        }
        return futures;
    }

    @Override
    public <V> IScheduledFuture<V> getScheduledFuture(ScheduledTaskHandler handler) {
        ClientScheduledFutureProxy futureProxy = new ClientScheduledFutureProxy(handler, this.getContext());
        return futureProxy;
    }

    @Override
    public <V> Map<Member, List<IScheduledFuture<V>>> getAllScheduledFutures() {
        long timeout = 10L;
        LinkedHashMap tasks = new LinkedHashMap();
        ArrayList<Member> members = new ArrayList<Member>(this.getContext().getClusterService().getMemberList());
        ArrayList calls = new ArrayList();
        for (Member member : members) {
            Address address = member.getAddress();
            ClientMessage request = ScheduledExecutorGetAllScheduledFuturesCodec.encodeRequest(this.getName(), address);
            calls.add(this.doSubmitOnAddress(request, GET_ALL_SCHEDULED_DECODER, address));
        }
        ArrayList resolvedFutures = new ArrayList(FutureUtil.returnWithDeadline(calls, 10L, TimeUnit.SECONDS));
        for (int i = 0; i < resolvedFutures.size(); ++i) {
            Member member = (Member)members.get(i);
            List handlers = (List)resolvedFutures.get(i);
            ArrayList<IScheduledFuture<V>> scheduledFutures = new ArrayList<IScheduledFuture<V>>();
            for (ScheduledTaskHandler handler : handlers) {
                scheduledFutures.add(this.createFutureProxy(handler));
            }
            if (scheduledFutures.isEmpty()) continue;
            tasks.put(member, scheduledFutures);
        }
        return tasks;
    }

    @Override
    public void shutdown() {
        Collection<Member> members = this.getContext().getClusterService().getMemberList();
        LinkedList<Future> calls = new LinkedList<Future>();
        for (Member member : members) {
            ClientMessage request = ScheduledExecutorShutdownCodec.encodeRequest(this.getName(), member.getAddress());
            calls.add(this.doSubmitOnAddress(request, SUBMIT_DECODER, member.getAddress()));
        }
        FutureUtil.waitWithDeadline(calls, 10L, TimeUnit.SECONDS, WHILE_SHUTDOWN_EXCEPTION_HANDLER);
    }

    private <T> ScheduledRunnableAdapter<T> createScheduledRunnableAdapter(Runnable command) {
        Preconditions.checkNotNull(command, "Command can't be null");
        return new ScheduledRunnableAdapter(command);
    }

    private <V> IScheduledFuture<V> createFutureProxy(ScheduledTaskHandler handler) {
        ClientScheduledFutureProxy proxy = new ClientScheduledFutureProxy(handler, this.getContext());
        return proxy;
    }

    private <V> IScheduledFuture<V> createFutureProxy(int partitionId, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of(partitionId, this.getName(), taskName));
    }

    private <V> IScheduledFuture<V> createFutureProxy(Address address, String taskName) {
        return this.createFutureProxy(ScheduledTaskHandlerImpl.of(address, this.getName(), taskName));
    }

    private int getKeyPartitionId(Object key) {
        return this.getClient().getPartitionService().getPartition(key).getPartitionId();
    }

    private int getTaskOrKeyPartitionId(Callable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private int getTaskOrKeyPartitionId(Runnable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private String extractNameOrGenerateOne(Object command) {
        String name = null;
        if (command instanceof NamedTask) {
            name = ((NamedTask)command).getName();
        }
        return name != null ? name : UuidUtil.newUnsecureUuidString();
    }

    private <V> IScheduledFuture<V> scheduleOnPartition(String name, TaskDefinition definition, int partitionId) {
        Object data = this.getSerializationService().toData(definition);
        ClientMessage request = ScheduledExecutorSubmitToPartitionCodec.encodeRequest(this.getName(), data);
        return this.scheduleOnPartition(name, request, SUBMIT_DECODER, partitionId);
    }

    private <V> IScheduledFuture<V> scheduleOnPartition(String name, ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, int partitionId) {
        clientMessage.setPartitionId(partitionId);
        this.doSubmitOnPartition(clientMessage, clientMessageDecoder, partitionId).join();
        return this.createFutureProxy(partitionId, name);
    }

    private <V> IScheduledFuture<V> scheduleOnMember(String name, Member member, TaskDefinition definition) {
        Object data = this.getSerializationService().toData(definition);
        ClientMessage request = ScheduledExecutorSubmitToAddressCodec.encodeRequest(this.getName(), member.getAddress(), data);
        this.doSubmitOnAddress(request, SUBMIT_DECODER, member.getAddress()).join();
        return this.createFutureProxy(member.getAddress(), name);
    }

    private <T> ClientDelegatingFuture<T> doSubmitOnPartition(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, int partitionId) {
        SerializationService serializationService = this.getContext().getSerializationService();
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, partitionId).invoke();
            return new ClientDelegatingFuture(future, serializationService, clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> ClientDelegatingFuture<T> doSubmitOnAddress(ClientMessage clientMessage, ClientMessageDecoder clientMessageDecoder, Address address) {
        SerializationService serializationService = this.getContext().getSerializationService();
        try {
            ClientInvocationFuture future = new ClientInvocation(this.getClient(), clientMessage, address).invoke();
            return new ClientDelegatingFuture(future, serializationService, clientMessageDecoder);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

