/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAddEntryListenerMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.nearcache.impl.invalidation.BatchNearCacheInvalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.SingleNearCacheInvalidation;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.nearcache.invalidation.InvalidationListener;
import com.hazelcast.map.impl.nearcache.invalidation.UuidFilter;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class MapAddNearCacheEntryListenerMessageTask
extends AbstractMapAddEntryListenerMessageTask<MapAddNearCacheEntryListenerCodec.RequestParameters> {
    public MapAddNearCacheEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected boolean isLocalOnly() {
        return ((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).localOnly;
    }

    @Override
    protected ClientMessage encodeEvent(Data keyData, Data newValueData, Data oldValueData, Data meringValueData, int type, String uuid, int numberOfAffectedEntries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected MapAddNearCacheEntryListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddNearCacheEntryListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddNearCacheEntryListenerCodec.encodeResponse((String)response);
    }

    @Override
    protected Object newMapListener() {
        return new ClientNearCacheInvalidationListenerImpl();
    }

    @Override
    protected EventFilter getEventFilter() {
        return new EventListenerFilter(((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).listenerFlags, new UuidFilter(this.endpoint.getUuid()));
    }

    private final class ClientNearCacheInvalidationListenerImpl
    implements InvalidationListener {
        private final int batchOrderKey;

        private ClientNearCacheInvalidationListenerImpl() {
            this.batchOrderKey = MapAddNearCacheEntryListenerMessageTask.this.nodeEngine.getLocalMember().hashCode();
        }

        @Override
        public void onInvalidate(Invalidation invalidation) {
            if (!MapAddNearCacheEntryListenerMessageTask.this.endpoint.isAlive()) {
                return;
            }
            if (invalidation instanceof BatchNearCacheInvalidation) {
                ExtractedParams params = this.extractParams((BatchNearCacheInvalidation)invalidation);
                ClientMessage message = MapAddNearCacheEntryListenerCodec.encodeIMapBatchInvalidationEvent(params.keys, params.sourceUuids, params.partitionUuids, params.sequences);
                MapAddNearCacheEntryListenerMessageTask.this.sendClientMessage(this.batchOrderKey, message);
                return;
            }
            if (invalidation instanceof SingleNearCacheInvalidation) {
                Data key = invalidation.getKey();
                ClientMessage message = MapAddNearCacheEntryListenerCodec.encodeIMapInvalidationEvent(key, invalidation.getSourceUuid(), invalidation.getPartitionUuid(), invalidation.getSequence());
                MapAddNearCacheEntryListenerMessageTask.this.sendClientMessage(key, message);
                return;
            }
            throw new IllegalArgumentException("Unknown invalidation message type " + invalidation);
        }

        private ExtractedParams extractParams(BatchNearCacheInvalidation batch) {
            List<Invalidation> invalidations = batch.getInvalidations();
            int size = invalidations.size();
            ArrayList<Data> keys = new ArrayList<Data>(size);
            ArrayList<String> sourceUuids = new ArrayList<String>(size);
            ArrayList<UUID> partitionUuids = new ArrayList<UUID>(size);
            ArrayList<Long> sequences = new ArrayList<Long>(size);
            for (Invalidation invalidation : invalidations) {
                keys.add(invalidation.getKey());
                sourceUuids.add(invalidation.getSourceUuid());
                partitionUuids.add(invalidation.getPartitionUuid());
                sequences.add(invalidation.getSequence());
            }
            return new ExtractedParams(keys, sourceUuids, partitionUuids, sequences);
        }

        private final class ExtractedParams {
            private final List<Data> keys;
            private final List<String> sourceUuids;
            private final List<UUID> partitionUuids;
            private final List<Long> sequences;

            public ExtractedParams(List<Data> keys, List<String> sourceUuids, List<UUID> partitionUuids, List<Long> sequences) {
                this.keys = keys;
                this.sourceUuids = sourceUuids;
                this.partitionUuids = partitionUuids;
                this.sequences = sequences;
            }
        }
    }
}

