/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEndpointManager;
import com.hazelcast.client.ClientEvent;
import com.hazelcast.client.ClientEventType;
import com.hazelcast.client.impl.ClientEndpointImpl;
import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.LoginException;

public class ClientEndpointManagerImpl
implements ClientEndpointManager {
    private static final int DESTROY_ENDPOINT_DELAY_MS = 1111;
    private final ILogger logger;
    private final ClientEngineImpl clientEngine;
    private final NodeEngine nodeEngine;
    @Probe(name="count", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Connection, ClientEndpoint> endpoints = new ConcurrentHashMap<Connection, ClientEndpoint>();
    @Probe(name="totalRegistrations", level=ProbeLevel.MANDATORY)
    private MwCounter totalRegistrations = MwCounter.newMwCounter();

    public ClientEndpointManagerImpl(ClientEngineImpl clientEngine, NodeEngine nodeEngine) {
        this.clientEngine = clientEngine;
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ClientEndpointManager.class);
        MetricsRegistry metricsRegistry = ((NodeEngineImpl)nodeEngine).getMetricsRegistry();
        metricsRegistry.scanAndRegister(this, "client.endpoint");
    }

    @Override
    public Set<ClientEndpoint> getEndpoints(String clientUuid) {
        Preconditions.checkNotNull(clientUuid, "clientUuid can't be null");
        HashSet<ClientEndpoint> endpointSet = new HashSet<ClientEndpoint>();
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            if (!clientUuid.equals(endpoint.getUuid())) continue;
            endpointSet.add(endpoint);
        }
        return endpointSet;
    }

    @Override
    public ClientEndpoint getEndpoint(Connection connection) {
        Preconditions.checkNotNull(connection, "connection can't be null");
        return (ClientEndpoint)this.endpoints.get(connection);
    }

    @Override
    public void registerEndpoint(ClientEndpoint endpoint) {
        Preconditions.checkNotNull(endpoint, "endpoint can't be null");
        Connection conn = endpoint.getConnection();
        if (this.endpoints.putIfAbsent(conn, endpoint) != null) {
            this.logger.severe("An endpoint already exists for connection:" + conn);
        } else {
            this.totalRegistrations.inc();
        }
    }

    @Override
    public void removeEndpoint(ClientEndpoint endpoint, String reason) {
        this.removeEndpoint(endpoint, false, reason);
    }

    @Override
    public void removeEndpoint(ClientEndpoint clientEndpoint, boolean closeImmediately, final String reason) {
        Preconditions.checkNotNull(clientEndpoint, "endpoint can't be null");
        ClientEndpointImpl endpoint = (ClientEndpointImpl)clientEndpoint;
        this.endpoints.remove(endpoint.getConnection());
        this.logger.info("Destroying " + endpoint);
        try {
            endpoint.destroy();
        }
        catch (LoginException e) {
            this.logger.warning(e);
        }
        final Connection connection = endpoint.getConnection();
        if (closeImmediately) {
            try {
                connection.close(reason, null);
            }
            catch (Throwable e) {
                this.logger.warning("While closing client connection: " + connection, e);
            }
        } else {
            this.nodeEngine.getExecutionService().schedule(new Runnable(){

                @Override
                public void run() {
                    if (connection.isAlive()) {
                        try {
                            connection.close(reason, null);
                        }
                        catch (Throwable e) {
                            ClientEndpointManagerImpl.this.logger.warning("While closing client connection: " + e.toString());
                        }
                    }
                }
            }, 1111L, TimeUnit.MILLISECONDS);
        }
        ClientEvent event = new ClientEvent(endpoint.getUuid(), ClientEventType.DISCONNECTED, endpoint.getSocketAddress(), endpoint.getClientType());
        this.clientEngine.sendClientEvent(event);
    }

    @Override
    public void clear() {
        this.endpoints.clear();
    }

    @Override
    public Collection<ClientEndpoint> getEndpoints() {
        return this.endpoints.values();
    }

    @Override
    public int size() {
        return this.endpoints.size();
    }

    @Override
    public Connection findLiveConnectionFor(String clientUuid) {
        for (ClientEndpoint endpoint : this.endpoints.values()) {
            Connection connection;
            if (!clientUuid.equals(endpoint.getUuid()) || !(connection = endpoint.getConnection()).isAlive()) continue;
            return connection;
        }
        return null;
    }
}

