/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;

public class NumberAverageAggregator<I>
extends AbstractAggregator<I, Double> {
    private double sum;
    private long count;

    public NumberAverageAggregator() {
    }

    public NumberAverageAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        ++this.count;
        Number extractedValue = (Number)this.extract(entry);
        this.sum += extractedValue.doubleValue();
    }

    @Override
    public void combine(Aggregator aggregator) {
        NumberAverageAggregator doubleAverageAggregator = (NumberAverageAggregator)aggregator;
        this.sum += doubleAverageAggregator.sum;
        this.count += doubleAverageAggregator.count;
    }

    @Override
    public Double aggregate() {
        if (this.count == 0L) {
            return null;
        }
        return this.sum / (double)this.count;
    }
}

