/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;

public class MinAggregator<I, R extends Comparable>
extends AbstractAggregator<I, R> {
    private R min;

    public MinAggregator() {
    }

    public MinAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        Comparable extractedValue = (Comparable)this.extract(entry);
        if (this.isCurrentlyGreaterThan(extractedValue)) {
            this.min = extractedValue;
        }
    }

    private boolean isCurrentlyGreaterThan(R otherValue) {
        return this.min == null || this.min.compareTo(otherValue) > 0;
    }

    @Override
    public void combine(Aggregator aggregator) {
        MinAggregator maxAggregator = (MinAggregator)aggregator;
        R valueFromOtherAggregator = maxAggregator.min;
        if (this.isCurrentlyGreaterThan(valueFromOtherAggregator)) {
            this.min = valueFromOtherAggregator;
        }
    }

    @Override
    public R aggregate() {
        return this.min;
    }
}

