/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.task.map.AbstractMapAddEntryListenerMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.nearcache.BatchInvalidator;
import com.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.CleaningNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.InvalidationListener;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.util.CollectionUtil;
import java.util.List;

public class MapAddNearCacheEntryListenerMessageTask
extends AbstractMapAddEntryListenerMessageTask<MapAddNearCacheEntryListenerCodec.RequestParameters> {
    public MapAddNearCacheEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected boolean isLocalOnly() {
        return ((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).localOnly;
    }

    @Override
    protected ClientMessage encodeEvent(Data keyData, Data newValueData, Data oldValueData, Data meringValueData, int type, String uuid, int numberOfAffectedEntries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    protected MapAddNearCacheEntryListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapAddNearCacheEntryListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapAddNearCacheEntryListenerCodec.encodeResponse((String)response);
    }

    @Override
    protected Object newMapListener() {
        return new ClientNearCacheInvalidationListenerImpl();
    }

    @Override
    protected EventFilter getEventFilter() {
        return new EventListenerFilter(((MapAddNearCacheEntryListenerCodec.RequestParameters)this.parameters).listenerFlags, TrueEventFilter.INSTANCE);
    }

    private final class ClientNearCacheInvalidationListenerImpl
    implements InvalidationListener {
        ClientNearCacheInvalidationListenerImpl() {
        }

        @Override
        public void onInvalidate(Invalidation event) {
            if (!MapAddNearCacheEntryListenerMessageTask.this.endpoint.isAlive()) {
                return;
            }
            this.sendEvent(event);
        }

        private void sendEvent(Invalidation event) {
            if (event instanceof BatchNearCacheInvalidation) {
                List<Data> keys = BatchInvalidator.getKeysExcludingSource((BatchNearCacheInvalidation)event, MapAddNearCacheEntryListenerMessageTask.this.getEndpoint().getUuid());
                if (!CollectionUtil.isEmpty(keys)) {
                    MapAddNearCacheEntryListenerMessageTask.this.sendClientMessage(((MapAddNearCacheEntryListenerCodec.RequestParameters)((MapAddNearCacheEntryListenerMessageTask)MapAddNearCacheEntryListenerMessageTask.this).parameters).name, MapAddNearCacheEntryListenerCodec.encodeIMapBatchInvalidationEvent(keys));
                }
            } else if (!MapAddNearCacheEntryListenerMessageTask.this.getEndpoint().getUuid().equals(event.getSourceUuid())) {
                if (event instanceof SingleNearCacheInvalidation) {
                    Data key = ((SingleNearCacheInvalidation)event).getKey();
                    MapAddNearCacheEntryListenerMessageTask.this.sendClientMessage(key, MapAddNearCacheEntryListenerCodec.encodeIMapInvalidationEvent(key));
                } else if (event instanceof CleaningNearCacheInvalidation) {
                    MapAddNearCacheEntryListenerMessageTask.this.sendClientMessage(((MapAddNearCacheEntryListenerCodec.RequestParameters)((MapAddNearCacheEntryListenerMessageTask)MapAddNearCacheEntryListenerMessageTask.this).parameters).name, MapAddNearCacheEntryListenerCodec.encodeIMapInvalidationEvent(null));
                }
            }
        }
    }
}

