/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.AbstractBackupCacheOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import java.io.IOException;

public class CacheRemoveBackupOperation
extends AbstractBackupCacheOperation
implements BackupOperation,
MutatingOperation {
    private boolean wanOriginated;

    public CacheRemoveBackupOperation() {
    }

    public CacheRemoveBackupOperation(String name, Data key) {
        super(name, key);
    }

    public CacheRemoveBackupOperation(String name, Data key, boolean wanOriginated) {
        this(name, key);
        this.wanOriginated = wanOriginated;
    }

    @Override
    public void runInternal() throws Exception {
        this.cache.removeRecord(this.key);
    }

    @Override
    public void afterRunInternal() throws Exception {
        if (!this.wanOriginated && this.cache.isWanReplicationEnabled()) {
            this.wanEventPublisher.publishWanReplicationRemoveBackup(this.name, this.key);
        }
    }

    @Override
    public int getId() {
        return 11;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.wanOriginated);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.wanOriginated = in.readBoolean();
    }
}

