/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import com.hazelcast.util.CollectionUtil;
import java.util.List;

public abstract class MapOperation
extends AbstractNamedOperation {
    protected transient MapService mapService;
    protected transient MapContainer mapContainer;
    protected transient MapServiceContext mapServiceContext;

    public MapOperation() {
    }

    public MapOperation(String name) {
        this.name = name;
    }

    public void setMapService(MapService mapService) {
        this.mapService = mapService;
    }

    public void setMapContainer(MapContainer mapContainer) {
        this.mapContainer = mapContainer;
    }

    @Override
    public void beforeRun() throws Exception {
        super.beforeRun();
        this.mapService = (MapService)this.getService();
        this.mapServiceContext = this.mapService.getMapServiceContext();
        this.mapContainer = this.mapServiceContext.getMapContainer(this.name);
        this.innerBeforeRun();
    }

    public void innerBeforeRun() throws Exception {
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void afterRun() throws Exception {
    }

    public void setThreadId(long threadId) {
        throw new UnsupportedOperationException();
    }

    public long getThreadId() {
        throw new UnsupportedOperationException();
    }

    protected final void invalidateNearCache(List<Data> keys) {
        if (!this.mapContainer.isInvalidationEnabled() || CollectionUtil.isEmpty(keys)) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().invalidate(this.name, keys, this.getCallerUuid());
    }

    protected final void invalidateNearCache(Data key) {
        if (!this.mapContainer.isInvalidationEnabled() || key == null) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().invalidate(this.name, key, this.getCallerUuid());
    }

    protected final void clearNearCache(boolean owner) {
        if (!this.mapContainer.isInvalidationEnabled()) {
            return;
        }
        NearCacheProvider nearCacheProvider = this.mapServiceContext.getNearCacheProvider();
        nearCacheProvider.getNearCacheInvalidator().clear(this.name, owner, this.getCallerUuid());
    }
}

