/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.EntryBackupOperation;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Map;

public class EntryOperation
extends LockAwareOperation
implements BackupAwareOperation,
MutatingOperation {
    protected Object oldValue;
    private EntryProcessor entryProcessor;
    private EntryEventType eventType;
    private Object response;
    private transient Object dataValue;

    public EntryOperation() {
    }

    public EntryOperation(String name, Data dataKey, EntryProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        ManagedContext managedContext = serializationService.getManagedContext();
        managedContext.initialize(this.entryProcessor);
    }

    @Override
    public void run() {
        long now = this.getNow();
        this.oldValue = this.recordStore.get(this.dataKey, false);
        Map.Entry entry = this.createMapEntry(this.dataKey, this.oldValue);
        this.response = this.process(entry);
        if (this.noOp(entry)) {
            return;
        }
        if (this.entryRemoved(entry, now)) {
            return;
        }
        this.entryAddedOrUpdated(entry, now);
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (this.eventType == null) {
            return;
        }
        this.invalidateNearCache(this.dataKey);
        this.publishEntryEvent();
        this.publishWanReplicationEvent();
        this.evict();
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public Operation getBackupOperation() {
        EntryBackupProcessor backupProcessor = this.entryProcessor.getBackupProcessor();
        return backupProcessor != null ? new EntryBackupOperation(this.name, this.dataKey, backupProcessor) : null;
    }

    @Override
    public boolean shouldBackup() {
        return this.entryProcessor.getBackupProcessor() != null;
    }

    @Override
    public int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    private long getLatencyFrom(long begin) {
        return Clock.currentTimeMillis() - begin;
    }

    private Data toData(Object obj) {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.toData(obj);
    }

    private long getNow() {
        return Clock.currentTimeMillis();
    }

    private boolean noOp(Map.Entry entry) {
        LazyMapEntry mapEntrySimple = (LazyMapEntry)entry;
        return !mapEntrySimple.isModified() || this.oldValue == null && entry.getValue() == null;
    }

    private boolean entryRemoved(Map.Entry entry, long now) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.remove(this.dataKey);
            this.getLocalMapStats().incrementRemoves(this.getLatencyFrom(now));
            this.eventType = EntryEventType.REMOVED;
            return true;
        }
        return false;
    }

    private void entryAddedOrUpdated(Map.Entry entry, long now) {
        Object value = entry.getValue();
        this.put(this.dataKey, value);
        this.getLocalMapStats().incrementPuts(this.getLatencyFrom(now));
        this.dataValue = value;
        this.eventType = this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
    }

    private void put(Data key, Object value) {
        this.recordStore.put(key, value, -1L);
    }

    private Data process(Map.Entry entry) {
        Object result = this.entryProcessor.process(entry);
        return this.toData(result);
    }

    private Map.Entry createMapEntry(Data key, Object value) {
        return new LazyMapEntry(key, value, this.getNodeEngine().getSerializationService());
    }

    private LocalMapStatsImpl getLocalMapStats() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        LocalMapStatsProvider localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        return localMapStatsProvider.getLocalMapStatsImpl(this.name);
    }

    private boolean hasRegisteredListenerForThisMap() {
        EventService eventService = this.getNodeEngine().getEventService();
        return eventService.hasEventRegistration("hz:impl:mapService", this.name);
    }

    private void nullifyOldValueIfNecessary() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        InMemoryFormat format = mapConfig.getInMemoryFormat();
        if (format == InMemoryFormat.OBJECT && this.eventType != EntryEventType.REMOVED) {
            this.oldValue = null;
        }
    }

    private void publishEntryEvent() {
        if (this.hasRegisteredListenerForThisMap()) {
            this.nullifyOldValueIfNecessary();
            MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
            mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.eventType, this.dataKey, this.oldValue, this.dataValue);
        }
    }

    private void publishWanReplicationEvent() {
        MapContainer mapContainer = this.mapContainer;
        if (mapContainer.getWanReplicationPublisher() == null && mapContainer.getWanMergePolicy() == null) {
            return;
        }
        MapEventPublisher mapEventPublisher = this.getMapEventPublisher();
        Data key = this.dataKey;
        if (EntryEventType.REMOVED.equals((Object)this.eventType)) {
            mapEventPublisher.publishWanReplicationRemove(this.name, key, this.getNow());
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                this.dataValue = this.toData(this.dataValue);
                EntryView<Data, Object> entryView = EntryViews.createSimpleEntryView(key, this.dataValue, record);
                mapEventPublisher.publishWanReplicationUpdate(this.name, entryView);
            }
        }
    }

    private MapEventPublisher getMapEventPublisher() {
        MapServiceContext mapServiceContext = this.mapService.getMapServiceContext();
        return mapServiceContext.getMapEventPublisher();
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }
}

